package info.u_team.u_team_core.api.registry;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1761;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import info.u_team.u_team_core.util.ServiceUtil;

public interface CreativeModeTabRegister extends Iterable<RegistryEntry<class_1761>> {
	
	static CreativeModeTabRegister create(String modid) {
		return new CreativeModeTabRegister() {
			
			private final CommonRegister<class_1761> register = CommonRegister.create(class_7924.field_44688, modid);
			
			@Override
			public RegistryEntry<class_1761> register(String name, BiConsumer<class_2960, class_1761.class_7913> consumer) {
				return register(name, location -> {
					final class_1761.class_7913 builder = createDefaultBuilder(location);
					consumer.accept(location, builder);
					return builder;
				});
			}
			
			@Override
			public RegistryEntry<class_1761> register(String name, Consumer<class_1761.class_7913> consumer) {
				return register(name, location -> {
					final class_1761.class_7913 builder = createDefaultBuilder(location);
					consumer.accept(builder);
					return builder;
				});
			}
			
			private static class_1761.class_7913 createDefaultBuilder(class_2960 location) {
				final class_1761.class_7913 builder = Builder.INSTANCE.create();
				builder.method_47321(class_2561.method_43471("creativetabs.%s.%s".formatted(location.method_12836(), location.method_12832())));
				return builder;
			}
			
			@Override
			public RegistryEntry<class_1761> register(String name, Function<class_2960, class_1761.class_7913> function) {
				return register.register(name, location -> function.apply(location).method_47324());
			}
			
			@Override
			public RegistryEntry<class_1761> register(String name, Supplier<class_1761.class_7913> supplier) {
				return register.register(name, () -> supplier.get().method_47324());
			}
			
			@Override
			public void register() {
				register.register();
			}
			
			@Override
			public String getModid() {
				return register.getModid();
			}
			
			@Override
			public class_5321<? extends class_2378<class_1761>> getRegistryKey() {
				return register.getRegistryKey();
			}
			
			@Override
			public Collection<RegistryEntry<class_1761>> getEntries() {
				return register.getEntries();
			}
			
			@Override
			public Iterator<RegistryEntry<class_1761>> iterator() {
				return register.iterator();
			}
			
			@Override
			public Iterable<class_1761> entryIterable() {
				return register.entryIterable();
			}
			
			@Override
			public CommonRegister<class_1761> getCommonRegister() {
				return register;
			}
		};
	}
	
	RegistryEntry<class_1761> register(String name, BiConsumer<class_2960, class_1761.class_7913> consumer);
	
	RegistryEntry<class_1761> register(String name, Consumer<class_1761.class_7913> consumer);
	
	RegistryEntry<class_1761> register(String name, Function<class_2960, class_1761.class_7913> function);
	
	RegistryEntry<class_1761> register(String name, Supplier<class_1761.class_7913> supplier);
	
	void register();
	
	String getModid();
	
	class_5321<? extends class_2378<class_1761>> getRegistryKey();
	
	Collection<RegistryEntry<class_1761>> getEntries();
	
	Iterable<class_1761> entryIterable();
	
	CommonRegister<class_1761> getCommonRegister();
	
	interface Builder {
		
		Builder INSTANCE = ServiceUtil.loadOne(Builder.class);
		
		class_1761.class_7913 create();
	}
}
