package info.u_team.u_team_core.api.network;

import java.util.function.BiConsumer;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface NetworkPayload<M> {
	
	static <M> NetworkPayload<M> of(NetworkHandlerEnvironment handlerEnvironment, class_9139<? super class_9129, M> streamCodec, BiConsumer<M, NetworkContext> handler) {
		return new NetworkPayload<>() {
			
			@Override
			public class_9139<? super class_9129, M> streamCodec() {
				return streamCodec;
			}
			
			@Override
			public NetworkHandlerEnvironment handlerEnvironment() {
				return handlerEnvironment;
			}
			
			@Override
			public void handle(M message, NetworkContext context) {
				handler.accept(message, context);
			}
		};
	}
	
	class_9139<? super class_9129, M> streamCodec();
	
	NetworkHandlerEnvironment handlerEnvironment();
	
	void handle(M message, NetworkContext context);
	
}
