package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.util.FontUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4286;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8666;

public class CheckboxButton extends UButton {
	
	protected static final class_8666 CHECKBOX_SPRITES = new class_8666(class_4286.field_45349, class_4286.field_45350, class_4286.field_45348, class_4286.field_45351);
	
	protected boolean checked;
	
	protected boolean drawText;
	protected boolean leftSideText;
	protected boolean dropShadow;
	
	public CheckboxButton(int x, int y, int width, int height, class_2561 text, boolean checked, boolean drawText) {
		this(x, y, width, height, text, checked, drawText, EMTPY_PRESSABLE);
	}
	
	public CheckboxButton(int x, int y, int width, int height, class_2561 text, boolean checked, boolean drawText, class_4241 pessable) {
		super(x, y, width, height, text, pessable);
		this.checked = checked;
		this.drawText = drawText;
		buttonTextureProvider = new WidgetTextureProvider(CHECKBOX_SPRITES, this::isChecked, this::method_25367);
	}
	
	public boolean isChecked() {
		return checked;
	}
	
	public void setChecked(boolean checked) {
		this.checked = checked;
	}
	
	public boolean isDrawText() {
		return drawText;
	}
	
	public void setDrawText(boolean drawText) {
		this.drawText = drawText;
	}
	
	public boolean isLeftSideText() {
		return leftSideText;
	}
	
	public void setLeftSideText(boolean leftSideText) {
		this.leftSideText = leftSideText;
	}
	
	public void toggle() {
		checked = !checked;
	}
	
	@Override
	public void method_25306() {
		toggle();
		super.method_25306();
	}
	
	@Override
	public void renderBefore(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		if (drawText) {
			final class_327 font = getCurrentTextFont();
			
			final class_2561 message = getCurrentText();
			if (message != class_5244.field_39003) {
				final float currentScale = getCurrentScale(guiGraphics, mouseX, mouseY, partialTick);
				
				final float positionFactor = 1 / currentScale;
				
				final float xStart;
				final float yStart = (field_22761 + ((int) (field_22759 - 8 * currentScale)) / 2) * positionFactor;
				
				if (leftSideText) {
					xStart = (field_22760 - ((font.method_27525(message) * currentScale) + 4)) * positionFactor;
				} else {
					xStart = (field_22760 + field_22758 + 4) * positionFactor;
				}
				
				final int color = WidgetUtil.respectWidgetAlpha(this, getCurrentTextColor(guiGraphics, mouseY, mouseY, partialTick)).getColorARGB();
				
				final class_4587 poseStack = guiGraphics.method_51448();
				poseStack.method_22903();
				poseStack.method_22905(currentScale, currentScale, 0);
				
				FontUtil.drawString(guiGraphics, font, getCurrentText(), xStart, yStart, color, dropShadow);
				
				poseStack.method_22909();
			}
		}
	}
	
	@Override
	public void method_47399(class_6382 output) {
		output.method_37034(class_6381.field_33788, method_25360());
		if (field_22763) {
			if (method_25370()) {
				output.method_37034(class_6381.field_33791, class_2561.method_43471("narration.checkbox.usage.focused"));
			} else {
				output.method_37034(class_6381.field_33791, class_2561.method_43471("narration.checkbox.usage.hovered"));
			}
		}
	}
}
