/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.init.network;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.menutype.UMenuType;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.RegistryUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1661;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_7924;

public record OpenMenuScreenMessage(int containerId, class_3917<?> type, class_2561 title, class_2540 extraData) {
    private static final class_2378<class_3917<?>> REGISTRY = RegistryUtil.getBuiltInRegistry(class_7924.field_41207);

    public static void encode(OpenMenuScreenMessage message, class_2540 buffer) {
        buffer.method_10804(message.containerId);
        buffer.method_42065(REGISTRY, message.type);
        buffer.method_10805(message.title);
        buffer.method_10804(message.extraData.readableBytes());
        buffer.writeBytes((ByteBuf)message.extraData);
        message.extraData.release();
    }

    public static OpenMenuScreenMessage decode(class_2540 buffer) {
        int containerId = buffer.method_10816();
        class_3917 type = (class_3917)buffer.method_42064(REGISTRY);
        class_2561 title = buffer.method_10808();
        class_2540 extraData = new class_2540(Unpooled.wrappedBuffer((byte[])buffer.method_10795()));
        return new OpenMenuScreenMessage(containerId, type, title, extraData);
    }

    public static class Handler {
        public static void handle(OpenMenuScreenMessage message, NetworkContext context) {
            context.executeOnMainThread(() -> {
                class_310 minecraft = class_310.method_1551();
                class_1661 playerInventory = minecraft.field_1724.method_31548();
                int containerId = message.containerId;
                class_3917<?> type = message.type;
                class_2561 title = message.title;
                class_2540 extraData = message.extraData;
                try {
                    Object menu;
                    if (message.type == null) {
                        class_3929.field_17408.warn("Trying to open invalid screen with name: {}", (Object)title.getString());
                        return;
                    }
                    class_3929.class_3930 constructor = (class_3929.class_3930)CastUtil.uncheckedCast(class_3929.method_17540(type));
                    if (constructor == null) {
                        class_3929.field_17408.warn("Failed to create screen for menu type: {}", (Object)REGISTRY.method_10221(type));
                        return;
                    }
                    if (type instanceof UMenuType) {
                        UMenuType uType = (UMenuType)type;
                        menu = uType.createWithExtraData(containerId, playerInventory, extraData);
                    } else {
                        menu = type.method_17434(containerId, playerInventory);
                    }
                    class_437 screen = constructor.create(menu, playerInventory, title);
                    if (!(screen instanceof class_3936)) {
                        class_3929.field_17408.warn("Trying to open invalid screen that does not implement MenuAccess with name: {}", (Object)title.getString());
                        return;
                    }
                    class_3936 menuAccess = (class_3936)screen;
                    minecraft.field_1724.field_7512 = menuAccess.method_17577();
                    minecraft.method_1507(screen);
                }
                finally {
                    extraData.release();
                }
            });
        }
    }
}

