/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.block;

import info.u_team.u_team_core.api.block.MenuSyncedBlockEntity;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.MenuUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;

public interface EntityBlockProvider
extends class_2343 {
    public class_2591<?> blockEntityType(class_2338 var1, class_2680 var2);

    default public class_2586 method_10123(class_2338 pos, class_2680 state) {
        class_2591<?> type = this.blockEntityType(pos, state);
        if (type != null) {
            return type.method_11032(pos, state);
        }
        return null;
    }

    default public <T extends class_2586> Optional<T> getBlockEntity(class_1922 level, class_2338 pos) {
        return this.getMatchingBlockEntity(level, pos);
    }

    default public class_1269 openMenu(class_1937 level, class_2338 pos, class_1657 player) {
        return this.openMenu(level, pos, player, false);
    }

    default public class_1269 openMenu(class_1937 level, class_2338 pos, class_1657 player, boolean canOpenWhenSecondaryUse) {
        if (level.method_8608() || !(player instanceof class_3222)) {
            return class_1269.field_5812;
        }
        class_3222 serverPlayer = (class_3222)player;
        Optional blockEntityOptional = this.getBlockEntity((class_1922)level, pos);
        if (!blockEntityOptional.isPresent()) {
            return class_1269.field_5811;
        }
        class_2586 blockEntity = (class_2586)blockEntityOptional.get();
        if (!(blockEntity instanceof class_3908)) {
            return class_1269.field_5811;
        }
        class_3908 menuProvider = (class_3908)blockEntity;
        if (!canOpenWhenSecondaryUse && serverPlayer.method_21823()) {
            return class_1269.field_5812;
        }
        class_2540 data = new class_2540(Unpooled.buffer());
        if (blockEntity instanceof MenuSyncedBlockEntity) {
            MenuSyncedBlockEntity syncedBlockEntity = (MenuSyncedBlockEntity)blockEntity;
            syncedBlockEntity.sendInitialMenuDataToClient(data);
        }
        MenuUtil.openMenu(serverPlayer, menuProvider, byteBuf -> {
            byteBuf.method_10807(pos);
            byteBuf.method_10804(data.readableBytes());
            byteBuf.writeBytes((ByteBuf)data);
            data.release();
        }, false);
        return class_1269.field_5812;
    }

    private <T extends class_2586> Optional<T> getMatchingBlockEntity(class_1922 level, class_2338 pos) {
        return (Optional)CastUtil.uncheckedCast(level.method_35230(pos, this.blockEntityType(pos, level.method_8320(pos))));
    }
}

