package info.u_team.u_team_core.util;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

/**
 * Some utility methods for level interaction.
 *
 * @author HyCraftHD
 */
public class LevelUtil {
	
	/**
	 * Raytrace from an entities look vector for collisions in range. Use default block mode {@link class_3960#field_17559} and fluid
	 * mode {@link class_242#field_1348}.
	 *
	 * @param entity Entity from where we get the look vector
	 * @param range Range in blocks
	 * @return Raytrace result with information about the trace
	 */
	public static class_239 rayTraceServerSide(class_1297 entity, double range) {
		return rayTraceServerSide(entity, range, class_3960.field_17559, class_242.field_1348);
	}
	
	/**
	 * Raytrace from an entities look vector for collisions in range.
	 *
	 * @param entity Entity from where we get the look vector
	 * @param range Range in blocks
	 * @param blockMode Mode for block collisions
	 * @param fluidMode Mode for fluid collisions
	 * @return Raytrace result with information about the trace
	 */
	public static class_239 rayTraceServerSide(class_1297 entity, double range, class_3960 blockMode, class_242 fluidMode) {
		final class_243 playerVector = entity.method_19538().method_1031(0, entity.method_5751(), 0);
		final class_243 lookVector = entity.method_5720();
		final class_243 locationVector = playerVector.method_1031(lookVector.field_1352 * range, lookVector.field_1351 * range, lookVector.field_1350 * range);
		return entity.method_37908().method_17742(new class_3959(playerVector, locationVector, blockMode, fluidMode, entity));
	}
	
	/**
	 * Get a saved instance (own implementation) of {@link class_18}. If it does not exist, a new one is created.
	 *
	 * @param <T> Custom level save data class
	 * @param level Server level
	 * @param name Name of this data
	 * @param defaultData Function for creating an instance and for the default instance
	 * @return An instance of <T> with the loaded data or default data.
	 */
	public static <T extends class_18> T getSaveData(class_3218 level, Function<class_2487, T> load, String name, Function<String, T> defaultData) {
		return getSaveData(level, name, load, () -> defaultData.apply(name));
	}
	
	/**
	 * Get a saved instance (own implementation) of {@link class_18}. If it does not exist, a new one is created.
	 *
	 * @param <T> Custom level save data class
	 * @param level Server level
	 * @param name Name of this data
	 * @param defaultData Supplier for creating an instance and for the default instance
	 * @return An instance of <T> with the loaded data or default data.
	 */
	public static <T extends class_18> T getSaveData(class_3218 level, String name, Function<class_2487, T> load, Supplier<T> defaultData) {
		return level.method_17983().method_17924(load, defaultData, name);
	}
	
	/**
	 * Get the {@link class_3218} from the {@link class_5321}
	 *
	 * @param entity An entity used to get the server instance with {@link class_1297#method_5682()}
	 * @param key The dimension key
	 * @return The server level for the given key
	 */
	public static class_3218 getServerLevel(class_1297 entity, class_5321<class_1937> key) {
		return getServerLevel(entity.method_5682(), key);
	}
	
	/**
	 * Get the {@link class_3218} from the {@link class_5321}
	 *
	 * @param server The server instance
	 * @param key The dimension key
	 * @return The server level for the given key
	 */
	public static class_3218 getServerLevel(MinecraftServer server, class_5321<class_1937> key) {
		return server.method_3847(key);
	}
	
	/**
	 * Teleports any entity to a given location in a given {@link class_3218}. Don't change the yaw and pitch of the
	 * entity.
	 *
	 * @param entity The entity to teleport
	 * @param key The dimension key where the entity should be teleported. Can be the same as the current dimension key or a
	 *        different one
	 * @param pos The position the entity should be teleported to
	 * @return The teleported entity
	 */
	public static class_1297 teleportEntity(class_1297 entity, class_5321<class_1937> key, class_2338 pos) {
		return teleportEntity(entity, key, class_243.method_24953(pos));
	}
	
	/**
	 * Teleports any entity to a given location in a given {@link class_3218}. Don't change the yaw and pitch of the
	 * entity.
	 *
	 * @param entity The entity to teleport
	 * @param key The dimension key where the entity should be teleported. Can be the same as the current dimension key or a
	 *        different one
	 * @param pos The position the entity should be teleported to
	 * @return The teleported entity
	 */
	public static class_1297 teleportEntity(class_1297 entity, class_5321<class_1937> key, class_243 pos) {
		return teleportEntity(entity, getServerLevel(entity, key), pos);
	}
	
	/**
	 * Teleports any entity to a given location in a given {@link class_3218}. Don't change the yaw and pitch of the
	 * entity.
	 *
	 * @param entity The entity to teleport
	 * @param level The server level where the entity should be teleported. Can be the same as the current level or a
	 *        different one
	 * @param pos The position the entity should be teleported to
	 * @return The teleported entity
	 */
	public static class_1297 teleportEntity(class_1297 entity, class_3218 level, class_2338 pos) {
		return teleportEntity(entity, level, class_243.method_24953(pos));
	}
	
	/**
	 * Teleports any entity to a given location in a given {@link class_3218}. Don't change the yaw and pitch of the
	 * entity.
	 *
	 * @param entity The entity to teleport
	 * @param level The server level where the entity should be teleported. Can be the same as the current level or a
	 *        different one
	 * @param pos The position the entity should be teleported to
	 * @return The teleported entity
	 */
	public static class_1297 teleportEntity(class_1297 entity, class_3218 level, class_243 pos) {
		return teleportEntity(entity, level, pos.method_10216(), pos.method_10214(), pos.method_10215(), entity.method_36454(), entity.method_36455());
	}
	
	/**
	 * Teleports any entity to a given location in a given {@link class_2874}.
	 *
	 * @param entity The entity to teleport
	 * @param key The dimension key where the entity should be teleported. Can be the same as the current dimension key or a
	 *        different one
	 * @param x X-Coordinate
	 * @param y Y-Coordinate
	 * @param z Z-Coordinate
	 * @param yaw Yaw
	 * @param pitch Pitch
	 * @return The teleported entity
	 */
	public static class_1297 teleportEntity(class_1297 entity, class_5321<class_1937> key, double x, double y, double z, float yaw, float pitch) {
		return teleportEntity(entity, getServerLevel(entity, key), x, y, z, yaw, pitch);
	}
	
	/**
	 * Teleports any entity to a given location in a given {@link class_3218}.
	 *
	 * @param entity The entity to teleport
	 * @param level The server level where the entity should be teleported. Can be the same as the current level or a
	 *        different one
	 * @param x X-Coordinate
	 * @param y Y-Coordinate
	 * @param z Z-Coordinate
	 * @param yaw Yaw
	 * @param pitch Pitch
	 * @return The teleported entity
	 */
	public static class_1297 teleportEntity(class_1297 entity, class_3218 level, double x, double y, double z, float yaw, float pitch) {
		return teleportEntity(entity, level, x, y, z, yaw, pitch, true);
	}
	
	/**
	 * Teleports any entity to a given location in a given {@link class_3218}.
	 *
	 * @param entity The entity to teleport
	 * @param level The server level where the entity should be teleported. Can be the same as the current level or a
	 *        different one
	 * @param x X-Coordinate
	 * @param y Y-Coordinate
	 * @param z Z-Coordinate
	 * @param yaw Yaw
	 * @param pitch Pitch
	 * @param detach Detach the entity
	 * @return The teleported entity
	 */
	public static class_1297 teleportEntity(class_1297 entity, class_3218 level, double x, double y, double z, float yaw, float pitch, boolean detach) {
		final float wrapedYaw = class_3532.method_15393(yaw);
		final float wrapedPitch = class_3532.method_15393(pitch);
		if (entity instanceof final class_3222 player) {
			level.method_14178().method_17297(class_3230.field_19347, new class_1923(class_2338.method_49637(x, y, z)), 1, entity.method_5628());
			if (detach) {
				player.method_5848();
			}
			if (player.method_6113()) {
				player.method_7358(true, true);
			}
			if (level == entity.method_37908()) {
				player.field_13987.method_14363(x, y, z, wrapedYaw, wrapedPitch);
			} else {
				player.method_14251(level, x, y, z, wrapedYaw, wrapedPitch);
			}
			entity.method_5847(wrapedYaw);
		} else {
			final float clampedPitch = class_3532.method_15363(wrapedPitch, -90F, 90F);
			if (level == entity.method_37908()) {
				entity.method_5808(x, y, z, wrapedYaw, clampedPitch);
				entity.method_5847(wrapedYaw);
			} else {
				if (detach) {
					entity.method_18375();
				}
				final class_1297 entityOld = entity;
				entity = entity.method_5864().method_5883(level);
				if (entity == null) {
					return null;
				}
				entity.method_5878(entityOld);
				entity.method_5808(x, y, z, wrapedYaw, clampedPitch);
				entity.method_5847(wrapedYaw);
				entityOld.method_31745(class_1297.class_5529.field_27002);
				level.method_18769(entity);
			}
		}
		
		if (!(entity instanceof final class_1309 livingEntity) || !livingEntity.method_6128()) {
			entity.method_18799(entity.method_18798().method_18805(1, 0, 1));
			entity.method_24830(true);
		}
		
		if (entity instanceof final class_1314 pathFinderMob) {
			pathFinderMob.method_5942().method_6340();
		}
		
		return entity;
	}
}
