package info.u_team.u_team_core.item.food;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1293;
import net.minecraft.class_4174;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;

import info.u_team.u_team_core.util.ServiceUtil;

public class UFoodPropertiesBuilder extends class_4174.class_4175 {
	
	public static UFoodPropertiesBuilder builder() {
		return new UFoodPropertiesBuilder();
	}
	
	private static final Creator CREATOR = ServiceUtil.loadOne(Creator.class);
	
	private final List<Pair<Supplier<class_1293>, Float>> effects = new ArrayList<>();
	
	protected UFoodPropertiesBuilder() {
	}
	
	@Override
	public UFoodPropertiesBuilder method_19238(int nutrition) {
		super.method_19238(nutrition);
		return this;
	}
	
	@Override
	public UFoodPropertiesBuilder method_19237(float saturationModifier) {
		super.method_19237(saturationModifier);
		return this;
	}
	
	@Override
	public UFoodPropertiesBuilder method_19236() {
		super.method_19236();
		return this;
	}
	
	@Override
	public UFoodPropertiesBuilder method_19240() {
		super.method_19240();
		return this;
	}
	
	@Override
	public UFoodPropertiesBuilder method_19241() {
		super.method_19241();
		return this;
	}
	
	@Override
	public UFoodPropertiesBuilder method_19239(class_1293 effect, float probability) {
		return effect(() -> effect, probability);
	}
	
	public UFoodPropertiesBuilder effect(Supplier<class_1293> effectSupplier, float probability) {
		effects.add(Pair.of(Suppliers.memoize(effectSupplier::get), probability));
		return this;
	}
	
	@Override
	public class_4174 method_19242() {
		return CREATOR.create(field_18620, field_18621, field_18622, field_18623, field_18624, effects);
	}
	
	public static interface Creator {
		
		class_4174 create(int nutrition, float saturationModifier, boolean isMeat, boolean canAlwaysEat, boolean fastFood, List<Pair<Supplier<class_1293>, Float>> effects);
	}
	
}
