package info.u_team.u_team_core.item.armor;

import java.util.function.Supplier;
import net.minecraft.class_1856;
import net.minecraft.class_3414;

public class UArmorMaterialVanilla extends UArmorMaterial {
	
	protected final String texture;
	
	public UArmorMaterialVanilla(int durability, int[] armorPoints, int enchantability, Supplier<class_3414> soundEvent, float toughness, float knockbackResistance, Supplier<class_1856> ingredient) {
		this(null, durability, armorPoints, enchantability, soundEvent, toughness, knockbackResistance, ingredient);
	}
	
	public UArmorMaterialVanilla(String texture, int durability, int[] armorpoints, int enchantability, Supplier<class_3414> soundEvent, float toughness, float knockbackResistance, Supplier<class_1856> ingredient) {
		super(createDurabilityVanillaArray(durability), armorpoints, enchantability, soundEvent, toughness, knockbackResistance, ingredient);
		this.texture = texture;
	}
	
	@Override
	public String method_7694() {
		return texture == null ? super.method_7694() : texture;
	}
	
	private static final int[] BASE_DURABILITY = new int[] { 13, 15, 16, 11 };
	
	private static int[] createDurabilityVanillaArray(int durability) {
		final int[] array = new int[4];
		for (int index = 0; index < array.length; index++) {
			array[index] = BASE_DURABILITY[index] * durability;
		}
		return array;
	}
	
}
