package info.u_team.u_team_core.item.armor;

import info.u_team.u_team_core.api.registry.CommonRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.util.ItemProperties;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_1793;

public class ArmorSetCreator {
	
	public static ArmorSet create(CommonRegister<class_1792> register, String name, class_1793 properties, class_1741 material) {
		final RegistryEntry<UHelmetItem> helmet = register.register(name + "_helmet", () -> new UHelmetItem(name, new ItemProperties(properties), material));
		final RegistryEntry<UChestplateItem> chestplate = register.register(name + "_chestplate", () -> new UChestplateItem(name, new ItemProperties(properties), material));
		final RegistryEntry<ULeggingsItem> leggings = register.register(name + "_leggings", () -> new ULeggingsItem(name, new ItemProperties(properties), material));
		final RegistryEntry<UBootsItem> boots = register.register(name + "_boots", () -> new UBootsItem(name, new ItemProperties(properties), material));
		
		return new ArmorSet(helmet, chestplate, leggings, boots);
	}
}
