package info.u_team.u_team_core.intern.command.uteamcore;

import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;

import info.u_team.u_team_core.util.LevelUtil;

public class DimensionTeleportSubCommand {
	
	private static final String SUCCESS_TRANSLATION_STRING = "commands.uteamcore.dimteleport.success.";
	
	public static ArgumentBuilder<class_2168, ?> register() {
		return class_2170.method_9247("dimteleport") //
				.requires(source -> source.method_9259(2)) //
				.then(class_2170.method_9244("targets", class_2186.method_9306()) //
						.then(class_2170.method_9244("dimension", class_2181.method_9288()) //
								.executes(context -> {
									return execute(context.getSource(), class_2186.method_9317(context, "targets"), class_2181.method_9289(context, "dimension"));
								}) //
								.then(class_2170.method_9244("location", class_2277.method_9737()) //
										.executes(context -> {
											return execute(context.getSource(), class_2186.method_9317(context, "targets"), class_2181.method_9289(context, "dimension"), class_2277.method_9736(context, "location"));
										}) //
										.then(class_2170.method_9244("yaw", FloatArgumentType.floatArg(0, 360)) //
												.then(class_2170.method_9244("pitch", FloatArgumentType.floatArg(-90, 90)) //
														.executes(context -> {
															return execute(context.getSource(), class_2186.method_9317(context, "targets"), class_2181.method_9289(context, "dimension"), class_2277.method_9736(context, "location"), FloatArgumentType.getFloat(context, "yaw"), FloatArgumentType.getFloat(context, "pitch"));
														}))))));
	}
	
	private static int execute(class_2168 source, Collection<? extends class_1297> targets, class_3218 level) {
		targets.forEach(entity -> LevelUtil.teleportEntity(entity, level, entity.method_19538()));
		if (targets.size() == 1) {
			source.method_9226(() -> class_2561.method_43469(SUCCESS_TRANSLATION_STRING + "single", targets.iterator().next().method_5476(), level.method_27983().method_29177()), true);
		} else {
			source.method_9226(() -> class_2561.method_43469(SUCCESS_TRANSLATION_STRING + "multiple", targets.size(), level.method_27983().method_29177()), true);
		}
		return 0;
	}
	
	private static int execute(class_2168 source, Collection<? extends class_1297> targets, class_3218 level, class_243 pos) {
		targets.forEach(entity -> LevelUtil.teleportEntity(entity, level, pos));
		sendPositionInfo(source, targets, level, pos);
		return 0;
	}
	
	private static int execute(class_2168 source, Collection<? extends class_1297> targets, class_3218 level, class_243 pos, float yaw, float pitch) {
		targets.forEach(entity -> LevelUtil.teleportEntity(entity, level, pos.method_10216(), pos.method_10214(), pos.method_10215(), yaw, pitch));
		sendPositionInfo(source, targets, level, pos);
		return 0;
	}
	
	private static void sendPositionInfo(class_2168 source, Collection<? extends class_1297> targets, class_3218 level, class_243 pos) {
		if (targets.size() == 1) {
			source.method_9226(() -> class_2561.method_43469(SUCCESS_TRANSLATION_STRING + "position.single", targets.iterator().next().method_5476(), level.method_27983().method_29177(), pos.field_1352, pos.field_1351, pos.field_1350), true);
		} else {
			source.method_9226(() -> class_2561.method_43469(SUCCESS_TRANSLATION_STRING + "position.multiple", targets.size(), level.method_27983().method_29177(), pos.field_1352, pos.field_1351, pos.field_1350), true);
		}
	}
}
