package info.u_team.u_team_core.api.event;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;
import info.u_team.u_team_core.util.ServiceUtil;

public interface ClientEvents {
	
	static void registerStartClientTick(StartClientTick event) {
		Handler.INSTANCE.registerStartClientTick(event);
	}
	
	static void registerEndClientTick(EndClientTick event) {
		Handler.INSTANCE.registerEndClientTick(event);
	}
	
	static void registerStartClientLevelTick(StartClientLevelTick event) {
		Handler.INSTANCE.registerStartClientLevelTick(event);
	}
	
	static void registerEndClientLevelTick(EndClientLevelTick event) {
		Handler.INSTANCE.registerEndClientLevelTick(event);
	}
	
	static void registerScreenAfterKeyPressed(ScreenAfterKeyPressed event) {
		Handler.INSTANCE.registerScreenAfterKeyPressed(event);
	}
	
	static void registerItemTooltip(ItemTooltip event) {
		Handler.INSTANCE.registerItemTooltip(event);
	}
	
	interface Handler {
		
		Handler INSTANCE = ServiceUtil.loadOne(Handler.class);
		
		void registerStartClientTick(StartClientTick event);
		
		void registerEndClientTick(EndClientTick event);
		
		void registerStartClientLevelTick(StartClientLevelTick event);
		
		void registerEndClientLevelTick(EndClientLevelTick event);
		
		void registerScreenAfterKeyPressed(ScreenAfterKeyPressed event);
		
		void registerItemTooltip(ItemTooltip event);
	}
	
	@FunctionalInterface
	interface StartClientTick {
		
		void onStartTick(class_310 minecraft);
	}
	
	@FunctionalInterface
	interface EndClientTick {
		
		void onEndTick(class_310 minecraft);
	}
	
	@FunctionalInterface
	interface StartClientLevelTick {
		
		void onStartTick(class_638 level);
	}
	
	@FunctionalInterface
	interface EndClientLevelTick {
		
		void onEndTick(class_638 level);
	}
	
	@FunctionalInterface
	interface ScreenAfterKeyPressed {
		
		boolean onKeyPressed(class_437 screen, int keyCode, int scanCode, int modifiers);
	}
	
	@FunctionalInterface
	interface ItemTooltip {
		
		void onTooltip(class_1799 stack, class_1836 flag, List<class_2561> lines);
	}
	
}
