/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.level;

import info.u_team.overworld_mirror.level.DimensionDataLevelSavedData;
import info.u_team.u_team_core.util.LevelUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.timers.TimerQueue;

public class CustomTimeLevelData
implements ServerLevelData {
    private final ServerLevelData info;
    private boolean firstTick;
    private long dayTime;

    public CustomTimeLevelData(ServerLevelData info) {
        this.info = info;
    }

    public void tick(ServerLevel level) {
        if (!this.firstTick) {
            this.firstTick = true;
            this.setDayTime(this.getSavedData(level).getDayTime());
        }
        if (this.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
            this.setDayTime(this.getDayTime() + 1L);
        }
        this.getSavedData(level).updateDayTime(this.getDayTime());
    }

    public DimensionDataLevelSavedData getSavedData(ServerLevel level) {
        String name = "overworldmirror_dimensiondata";
        return (DimensionDataLevelSavedData)LevelUtil.getSaveData((ServerLevel)level, (String)"overworldmirror_dimensiondata", DimensionDataLevelSavedData::load, DimensionDataLevelSavedData::new);
    }

    public void setDayTime(long time) {
        this.dayTime = time;
    }

    public long getDayTime() {
        return this.dayTime;
    }

    public void setThundering(boolean thunderingIn) {
        this.info.setThundering(thunderingIn);
    }

    public int getRainTime() {
        return this.info.getRainTime();
    }

    public boolean isThundering() {
        return this.info.isThundering();
    }

    public void setRainTime(int time) {
        this.info.setRainTime(time);
    }

    public boolean isRaining() {
        return this.info.isRaining();
    }

    public void setThunderTime(int time) {
        this.info.setThunderTime(time);
    }

    public void setRaining(boolean isRaining) {
        this.info.setRaining(isRaining);
    }

    public int getThunderTime() {
        return this.info.getThunderTime();
    }

    public int getClearWeatherTime() {
        return this.info.getClearWeatherTime();
    }

    public void setClearWeatherTime(int time) {
        this.info.setClearWeatherTime(time);
    }

    public String getLevelName() {
        return this.info.getLevelName();
    }

    public float getSpawnAngle() {
        return this.info.getSpawnAngle();
    }

    public void setSpawn(BlockPos spawnPoint, float angle) {
        this.info.setSpawn(spawnPoint, angle);
    }

    public long getGameTime() {
        return this.info.getGameTime();
    }

    public boolean isHardcore() {
        return this.info.isHardcore();
    }

    public GameRules getGameRules() {
        return this.info.getGameRules();
    }

    public Difficulty getDifficulty() {
        return this.info.getDifficulty();
    }

    public boolean isDifficultyLocked() {
        return this.info.isDifficultyLocked();
    }

    public int getWanderingTraderSpawnDelay() {
        return this.info.getWanderingTraderSpawnDelay();
    }

    public void setWanderingTraderSpawnDelay(int delay) {
        this.info.setWanderingTraderSpawnDelay(delay);
    }

    public int getWanderingTraderSpawnChance() {
        return this.info.getWanderingTraderSpawnChance();
    }

    public void setWanderingTraderSpawnChance(int chance) {
        this.info.setWanderingTraderSpawnChance(chance);
    }

    public UUID getWanderingTraderId() {
        return this.info.getWanderingTraderId();
    }

    public void setWanderingTraderId(UUID id) {
        this.info.setWanderingTraderId(id);
    }

    public GameType getGameType() {
        return this.info.getGameType();
    }

    public void setWorldBorder(WorldBorder.Settings serializer) {
        this.info.setWorldBorder(serializer);
    }

    public WorldBorder.Settings getWorldBorder() {
        return this.info.getWorldBorder();
    }

    public boolean isInitialized() {
        return this.info.isInitialized();
    }

    public void setInitialized(boolean initializedIn) {
        this.info.setInitialized(initializedIn);
    }

    public void setGameType(GameType type) {
        this.info.setGameType(type);
    }

    public TimerQueue<MinecraftServer> getScheduledEvents() {
        return this.info.getScheduledEvents();
    }

    public void setGameTime(long time) {
        this.info.setGameTime(time);
    }

    public BlockPos getSpawnPos() {
        return this.info.getSpawnPos();
    }

    public boolean isAllowCommands() {
        return this.info.isAllowCommands();
    }

    public float getDayTimeFraction() {
        return 0.0f;
    }

    public float getDayTimePerTick() {
        return 0.0f;
    }

    public void setDayTimeFraction(float dayTimeFraction) {
    }

    public void setDayTimePerTick(float dayTimePerTick) {
    }
}

