/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.util;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.realmsclient.RealmsAvailability;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import com.mojang.util.UndashedUuid;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.SimpleMinecraftAuthentication;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.method.AuthenticationMethod;
import info.u_team.oauth_account_manager.util.LoadedAccount;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;
import net.minecraft.client.telemetry.ClientTelemetryManager;
import net.minecraft.server.LoggedPrintStream;
import org.slf4j.LoggerFactory;

public class AuthenticationUtil {
    private static final HttpClient CLIENT = HttpClient.newHttpClient();

    public static CompletableFuture<Boolean> isAccessTokenValid(String accessToken) {
        URI uri;
        try {
            uri = new URI("https://api.minecraftservices.com/minecraft/profile");
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
        HttpRequest request = HttpRequest.newBuilder(uri).header("Authorization", "Bearer " + accessToken).timeout(Duration.ofSeconds(15L)).GET().build();
        return CLIENT.sendAsync(request, HttpResponse.BodyHandlers.discarding()).thenApply(response -> response.statusCode() == 200);
    }

    public static AuthenticationMethod createWebAuthenticationMethod() {
        return SimpleMinecraftAuthentication.getMethod("web").get().create((PrintStream)new LoggedPrintStream("OAuth-Account-Manager", (OutputStream)System.out), System.in);
    }

    public static MinecraftAccountData createMinecraftAccountData(LoadedAccount loadedAccount) throws AuthenticationException {
        Minecraft minecraft = Minecraft.getInstance();
        info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.User msUser = loadedAccount.user();
        User user = new User(msUser.name(), UndashedUuid.fromStringLenient((String)msUser.uuid()), msUser.accessToken(), Optional.of(msUser.xuid()), Optional.of(msUser.clientId()), User.Type.byName((String)msUser.type()));
        CompletableFuture<ProfileResult> profileFuture = CompletableFuture.supplyAsync(() -> minecraft.getMinecraftSessionService().fetchProfile(user.getProfileId(), true), Util.nonCriticalIoPool());
        UserApiService userApiService = minecraft.authenticationService.createUserApiService(msUser.accessToken());
        CompletableFuture<UserApiService.UserProperties> userPropertiesFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return userApiService.fetchProperties();
            }
            catch (AuthenticationException ex) {
                LoggerFactory.getLogger(Minecraft.class).error("Failed to fetch user properties", (Throwable)ex);
                return UserApiService.OFFLINE_PROPERTIES;
            }
        }, Util.nonCriticalIoPool());
        PlayerSocialManager playerSocialManager = new PlayerSocialManager(minecraft, userApiService);
        ClientTelemetryManager clientTelemetryManager = new ClientTelemetryManager(minecraft, userApiService, user);
        ProfileKeyPairManager profileKeyPairManager = ProfileKeyPairManager.create((UserApiService)userApiService, (User)user, (Path)minecraft.gameDirectory.toPath());
        ReportingContext reportingContext = ReportingContext.create((ReportEnvironment)ReportEnvironment.local(), (UserApiService)userApiService);
        return new MinecraftAccountData(user, profileFuture, userApiService, userPropertiesFuture, playerSocialManager, clientTelemetryManager, profileKeyPairManager, reportingContext);
    }

    public static void setMinecraftAccountData(MinecraftAccountData data) {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.user = data.user;
        minecraft.profileFuture = data.profileFuture;
        minecraft.userApiService = data.userApiService;
        minecraft.userPropertiesFuture = data.userPropertiesFuture;
        minecraft.getSplashManager().user = data.user;
        minecraft.playerSocialManager = data.playerSocialManager;
        minecraft.telemetryManager = data.telemetryManager;
        minecraft.profileKeyPairManager = data.profileKeyPairManager;
        minecraft.reportingContext = data.reportingContext;
        RealmsClient realmsClient = RealmsClient.create((Minecraft)minecraft);
        minecraft.realmsDataFetcher = new RealmsDataFetcher(realmsClient);
        RealmsAvailability.future = null;
    }

    public record MinecraftAccountData(User user, CompletableFuture<ProfileResult> profileFuture, UserApiService userApiService, CompletableFuture<UserApiService.UserProperties> userPropertiesFuture, PlayerSocialManager playerSocialManager, ClientTelemetryManager telemetryManager, ProfileKeyPairManager profileKeyPairManager, ReportingContext reportingContext) {
    }
}

