/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.util;

import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationFile;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.SimpleMinecraftAuthentication;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.creator.AuthenticationMethodCreator;
import java.io.IOException;

public class SimpleAuthenticationFileUtil {
    public static byte[] write(AuthenticationData data) throws IOException {
        AuthenticationFile file = data.file();
        file.getExtraProperties().put("method", data.creator().name());
        return file.writeCompressed();
    }

    public static AuthenticationData read(byte[] bytes) throws IOException {
        AuthenticationFile file = AuthenticationFile.readCompressed(bytes);
        String method = file.getExtraProperties().get("method");
        AuthenticationMethodCreator creator = SimpleMinecraftAuthentication.getMethod(method).orElseThrow(() -> new IOException("Cannot find unknown method '" + method + "' for authentication"));
        return new AuthenticationData(file, creator);
    }

    public record AuthenticationData(AuthenticationFile file, AuthenticationMethodCreator creator) {
    }
}

