/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.util;

import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationException;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.util.AuthenticationTimeoutException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AuthenticationFutureUtil {
    public static <T> T runAuthentication(ExecutorService executor, Callable<T> callable, int timeout, boolean allowNullResult) throws AuthenticationException {
        Future<T> future = executor.submit(callable);
        try {
            T result = future.get(timeout, TimeUnit.SECONDS);
            if (!allowNullResult && result == null) {
                throw new TimeoutException("Result was null as the authentication method did not complete correctly");
            }
            return result;
        }
        catch (InterruptedException ex) {
            future.cancel(true);
            throw new AuthenticationTimeoutException("Authentication was canceled from outside", ex);
        }
        catch (TimeoutException ex) {
            throw new AuthenticationTimeoutException("Authentication was not completed in " + timeout + " seconds", ex);
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof AuthenticationException) {
                AuthenticationException authenticationException = (AuthenticationException)throwable;
                throw authenticationException;
            }
            throw new AuthenticationException("An exception in the simple authenticator occured", ex);
        }
        catch (Exception ex) {
            throw new AuthenticationException("An unknown exception occured", ex);
        }
    }
}

