/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util;

import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.HttpPayload;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.HttpResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.function.ConsumerWithIOException;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.function.FunctionWithIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class ConnectionUtil {
    public static final String JSON_CONTENT_TYPE = "application/json";
    public static final String URL_ENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final ConsumerWithIOException<HttpURLConnection> NO_OP = urlConnection -> {};

    public static HttpResponse jsonPostRequest(URL url, HttpPayload payload, TimeoutValues timeoutValues) throws IOException {
        return ConnectionUtil.postRequest(url, JSON_CONTENT_TYPE, JSON_CONTENT_TYPE, payload, NO_OP, timeoutValues);
    }

    public static HttpResponse urlEncodedPostRequest(URL url, String acceptType, Map<String, Object> parameters, TimeoutValues timeoutValues) throws IOException {
        return ConnectionUtil.postRequest(url, acceptType, URL_ENCODED_CONTENT_TYPE, HttpPayload.fromString(ConnectionUtil.createUrlEncodedParameters(parameters, false)), NO_OP, timeoutValues);
    }

    public static HttpResponse bearerAuthorizationJsonGetRequest(URL url, String token, TimeoutValues timeoutValues) throws IOException {
        return ConnectionUtil.authorizationJsonGetRequest(url, "Bearer " + token, NO_OP, timeoutValues);
    }

    public static HttpResponse authorizationJsonGetRequest(URL url, String authorization, ConsumerWithIOException<HttpURLConnection> preConnect, TimeoutValues timeoutValues) throws IOException {
        return ConnectionUtil.getRequest(url, JSON_CONTENT_TYPE, urlConnection -> {
            urlConnection.setRequestProperty("Authorization", authorization);
            preConnect.accept((HttpURLConnection)urlConnection);
        }, timeoutValues);
    }

    public static HttpResponse postRequest(URL url, String acceptType, String contentType, HttpPayload payload, ConsumerWithIOException<HttpURLConnection> preConnect, TimeoutValues timeoutValues) throws IOException {
        return ConnectionUtil.basicRequest(url, "POST", acceptType, urlConnection -> {
            urlConnection.setDoOutput(true);
            urlConnection.setRequestProperty("Charset", StandardCharsets.UTF_8.name());
            urlConnection.setRequestProperty("Content-Type", contentType);
            urlConnection.setFixedLengthStreamingMode(payload.getSize());
            preConnect.accept((HttpURLConnection)urlConnection);
        }, urlConnection -> {
            if (payload.hasContent()) {
                try (OutputStream outputStream = urlConnection.getOutputStream();){
                    payload.write(outputStream);
                }
            }
        }, timeoutValues);
    }

    public static HttpResponse getRequest(URL url, String acceptType, ConsumerWithIOException<HttpURLConnection> preConnect, TimeoutValues timeoutValues) throws IOException {
        return ConnectionUtil.basicRequest(url, "GET", acceptType, preConnect, NO_OP, timeoutValues);
    }

    public static HttpResponse basicRequest(URL url, String method, String acceptType, ConsumerWithIOException<HttpURLConnection> preConnect, ConsumerWithIOException<HttpURLConnection> postConnect, TimeoutValues timeoutValues) throws IOException {
        HttpResponse httpResponse;
        block14: {
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setConnectTimeout(timeoutValues.connectTimeout());
            urlConnection.setReadTimeout(timeoutValues.readTimeout());
            urlConnection.setUseCaches(false);
            urlConnection.setInstanceFollowRedirects(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestMethod(method);
            urlConnection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
            urlConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
            urlConnection.setRequestProperty("Accept", acceptType);
            urlConnection.setRequestProperty("User-Agent", "Minecraft-Authenticator");
            preConnect.accept(urlConnection);
            urlConnection.connect();
            postConnect.accept(urlConnection);
            InputStream inputStream = ConnectionUtil.getInputStream(urlConnection, URLConnection::getInputStream);
            try {
                httpResponse = HttpResponse.fromStream(urlConnection.getResponseCode(), inputStream);
                if (inputStream == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    try (InputStream inputStream2 = ConnectionUtil.getInputStream(urlConnection, HttpURLConnection::getErrorStream);){
                        HttpResponse httpResponse2 = HttpResponse.fromStream(urlConnection.getResponseCode(), inputStream2);
                        return httpResponse2;
                    }
                }
            }
            inputStream.close();
        }
        return httpResponse;
    }

    private static InputStream getInputStream(HttpURLConnection urlConnection, FunctionWithIOException<HttpURLConnection, InputStream> function) throws IOException {
        String encoding = urlConnection.getContentEncoding();
        InputStream inputStream = function.apply(urlConnection);
        if ("gzip".equalsIgnoreCase(encoding)) {
            return new GZIPInputStream(inputStream);
        }
        if ("deflate".equalsIgnoreCase(encoding)) {
            return new InflaterInputStream(inputStream, new Inflater(true));
        }
        return inputStream;
    }

    public static URL urlBuilder(String url) throws MalformedURLException {
        return ConnectionUtil.urlBuilder(url, (String)null);
    }

    public static URL urlBuilder(String baseUrl, String path) throws MalformedURLException {
        return ConnectionUtil.urlBuilder(baseUrl, path, Collections.emptyMap());
    }

    public static URL urlBuilder(String url, Map<String, Object> parameters) throws MalformedURLException {
        return ConnectionUtil.urlBuilder(url, null, parameters);
    }

    public static URL urlBuilder(String baseUrl, String path, Map<String, Object> parameters) throws MalformedURLException {
        StringBuilder builder = new StringBuilder();
        builder.append(baseUrl);
        if (path != null && !path.isEmpty()) {
            builder.append("/");
            builder.append(path);
        }
        if (!parameters.isEmpty()) {
            builder.append("?");
        }
        ConnectionUtil.appendUrlEncodedParameters(builder, parameters, true);
        return new URL(builder.toString());
    }

    private static String createUrlEncodedParameters(Map<String, Object> parameters, boolean percent20) {
        StringBuilder builder = new StringBuilder();
        ConnectionUtil.appendUrlEncodedParameters(builder, parameters, percent20);
        return builder.toString();
    }

    private static StringBuilder appendUrlEncodedParameters(StringBuilder builder, Map<String, Object> parameters, boolean percent20) {
        boolean needAnd = false;
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (needAnd) {
                builder.append("&");
            }
            needAnd = true;
            builder.append(ConnectionUtil.escape(entry.getKey(), percent20));
            builder.append("=");
            builder.append(ConnectionUtil.escape(entry.getValue(), percent20));
        }
        return builder;
    }

    private static String escape(Object object, boolean percent20) {
        String encoded = URLEncoder.encode(object.toString(), StandardCharsets.UTF_8);
        if (percent20) {
            return encoded.replace("+", "%20");
        }
        return encoded;
    }

    public record TimeoutValues(int connectTimeout, int readTimeout) {
    }
}

