/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.Constants;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationFile;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftAuthenticationFile;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftAuthenticationFileSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class AuthenticationFileUtil {
    public static void toCompressedOutputStream(AuthenticationFile authFile, OutputStream outputStream) throws IOException {
        outputStream.write(AuthenticationFileUtil.toCompressedBytes(authFile));
    }

    public static byte[] toCompressedBytes(AuthenticationFile authFile) throws IOException {
        String json = AuthenticationFileUtil.toString(authFile);
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gZipOutputStream = new GZIPOutputStream(outputStream);){
                gZipOutputStream.write(bytes);
                gZipOutputStream.finish();
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
    }

    public static String toString(AuthenticationFile authFile) {
        JsonObject object = AuthenticationFileUtil.toJson(authFile);
        return Constants.GSON.toJson((JsonElement)object);
    }

    public static JsonObject toJson(AuthenticationFile authFile) {
        JsonObject object = new JsonObject();
        object.addProperty("warning", "DO NOT SHARE THIS FILE. IT CONTAINS LOGIN INFORMATION FOR YOUR MINECRAFT ACCOUNT!");
        object.add("file", AuthenticationFileUtil.serializeTypes(authFile));
        return object;
    }

    public static AuthenticationFile fromCompressedInputStream(InputStream inputStream) throws IOException {
        return AuthenticationFileUtil.fromCompressedBytes(inputStream.readAllBytes());
    }

    public static AuthenticationFile fromCompressedBytes(byte[] compressedBytes) throws IOException {
        byte[] bytes;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(compressedBytes);
             GZIPInputStream gZipInputStream = new GZIPInputStream(inputStream);){
            bytes = gZipInputStream.readAllBytes();
        }
        String json = new String(bytes, StandardCharsets.UTF_8);
        return AuthenticationFileUtil.fromString(json);
    }

    public static AuthenticationFile fromString(String json) throws IOException {
        JsonObject object;
        try {
            object = JsonParser.parseString((String)json).getAsJsonObject();
        }
        catch (JsonParseException | ClassCastException | IllegalStateException ex) {
            throw new IOException("Cannot parse authentication file", ex);
        }
        return AuthenticationFileUtil.fromJson(object);
    }

    public static AuthenticationFile fromJson(JsonObject object) throws IOException {
        try {
            return AuthenticationFileUtil.deserializeTypes(object.get("file"));
        }
        catch (JsonParseException | ClassCastException | IllegalStateException ex) {
            throw new IOException("Cannot parse authentication file", ex);
        }
    }

    private static JsonElement serializeTypes(AuthenticationFile authFile) {
        if (authFile instanceof MicrosoftAuthenticationFile) {
            MicrosoftAuthenticationFile microsoftFile = (MicrosoftAuthenticationFile)authFile;
            JsonObject jsonObject = MicrosoftAuthenticationFileSerializer.serialize(microsoftFile);
            jsonObject.addProperty("type", "microsoft");
            return jsonObject;
        }
        throw new IllegalStateException("AuthenticationFile must be a microsoft authentication file");
    }

    private static AuthenticationFile deserializeTypes(JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String type = jsonObject.get("type").getAsString();
        if ("microsoft".equals(type)) {
            return MicrosoftAuthenticationFileSerializer.deserialize(jsonObject);
        }
        throw new IllegalStateException("AuthenticationFile must be a microsoft authentication file. Type '" + type + "' is not supported");
    }
}

