/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.Constants;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.MinecraftHasPurchasedResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.MinecraftLauncherLoginPayload;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.MinecraftLauncherLoginResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.MinecraftProfileResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.OAuthErrorResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.OAuthTokenResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.XBLAuthenticatePayload;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.XBLAuthenticateResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.XBoxProfileResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.XBoxResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.XSTSAuthorizeErrorResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.XSTSAuthorizePayload;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.XSTSAuthorizeResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.service.MicrosoftResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.ConnectionUtil;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.HttpPayload;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.HttpResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.Parameters;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class MicrosoftService {
    public static URL oAuthLoginUrl() {
        return MicrosoftService.oAuthLoginUrl("00000000402b5328", "https://login.live.com/oauth20_desktop.srf");
    }

    public static URL oAuthLoginUrl(String clientId, String redirectUrl) {
        return MicrosoftService.oAuthLoginUrl(clientId, redirectUrl, null);
    }

    public static URL oAuthLoginUrl(String clientId, String redirectUrl, String clientSecret) {
        Parameters parameters = Parameters.create().add("client_id", clientId).add("response_type", "code").add("scope", "XboxLive.signin offline_access").add("redirect_uri", redirectUrl);
        if (clientSecret != null) {
            parameters.add("client_secret", clientSecret);
        }
        try {
            return ConnectionUtil.urlBuilder("https://login.live.com", "oauth20_authorize.srf", parameters);
        }
        catch (MalformedURLException ex) {
            throw new AssertionError("This url should never be malformed.", ex);
        }
    }

    public static MicrosoftResponse<OAuthTokenResponse, OAuthErrorResponse> oAuthTokenFromCode(String authorizationCode, ConnectionUtil.TimeoutValues timeoutValues) {
        return MicrosoftService.oAuthTokenFromCode("00000000402b5328", "https://login.live.com/oauth20_desktop.srf", authorizationCode, timeoutValues);
    }

    public static MicrosoftResponse<OAuthTokenResponse, OAuthErrorResponse> oAuthTokenFromCode(String clientId, String redirectUrl, String authorizationCode, ConnectionUtil.TimeoutValues timeoutValues) {
        return MicrosoftService.oAuthTokenFromCode(clientId, redirectUrl, null, authorizationCode, timeoutValues);
    }

    public static MicrosoftResponse<OAuthTokenResponse, OAuthErrorResponse> oAuthTokenFromCode(String clientId, String redirectUrl, String clientSecret, String authorizationCode, ConnectionUtil.TimeoutValues timeoutValues) {
        Parameters parameters = Parameters.create().add("client_id", clientId).add("code", authorizationCode).add("grant_type", "authorization_code").add("redirect_uri", redirectUrl);
        if (clientSecret != null) {
            parameters.add("client_secret", clientSecret);
        }
        return MicrosoftService.oAuthServiceRequest(parameters, timeoutValues);
    }

    public static MicrosoftResponse<OAuthTokenResponse, OAuthErrorResponse> oAuthTokenFromRefreshToken(String refreshToken, ConnectionUtil.TimeoutValues timeoutValues) {
        return MicrosoftService.oAuthTokenFromRefreshToken("00000000402b5328", "https://login.live.com/oauth20_desktop.srf", refreshToken, timeoutValues);
    }

    public static MicrosoftResponse<OAuthTokenResponse, OAuthErrorResponse> oAuthTokenFromRefreshToken(String clientId, String redirectUrl, String refreshToken, ConnectionUtil.TimeoutValues timeoutValues) {
        return MicrosoftService.oAuthTokenFromRefreshToken(clientId, redirectUrl, null, refreshToken, timeoutValues);
    }

    public static MicrosoftResponse<OAuthTokenResponse, OAuthErrorResponse> oAuthTokenFromRefreshToken(String clientId, String redirectUrl, String clientSecret, String refreshToken, ConnectionUtil.TimeoutValues timeoutValues) {
        Parameters parameters = Parameters.create().add("client_id", clientId).add("refresh_token", refreshToken).add("grant_type", "refresh_token").add("redirect_uri", redirectUrl);
        if (clientSecret != null) {
            parameters.add("client_secret", clientSecret);
        }
        return MicrosoftService.oAuthServiceRequest(parameters, timeoutValues);
    }

    private static MicrosoftResponse<OAuthTokenResponse, OAuthErrorResponse> oAuthServiceRequest(Parameters parameters, ConnectionUtil.TimeoutValues timeoutValues) {
        JsonElement responseElement;
        try {
            URL url = ConnectionUtil.urlBuilder("https://login.live.com", "oauth20_token.srf");
            String responseString = ConnectionUtil.urlEncodedPostRequest(url, "application/json", parameters, timeoutValues).getAsString();
            responseElement = JsonParser.parseString((String)responseString);
        }
        catch (JsonParseException | IOException ex) {
            return MicrosoftResponse.ofException(ex);
        }
        try {
            JsonObject responseObject = responseElement.getAsJsonObject();
            if (responseObject.has("error")) {
                return MicrosoftResponse.ofError((OAuthErrorResponse)Constants.GSON.fromJson((JsonElement)responseObject, OAuthErrorResponse.class));
            }
            return MicrosoftResponse.ofResponse((OAuthTokenResponse)Constants.GSON.fromJson((JsonElement)responseObject, OAuthTokenResponse.class));
        }
        catch (Exception ex) {
            return MicrosoftResponse.ofException(ex);
        }
    }

    public static MicrosoftResponse<XBLAuthenticateResponse, Integer> xblAuthenticate(String accessToken, ConnectionUtil.TimeoutValues timeoutValues) {
        JsonElement responseElement;
        XBLAuthenticatePayload payload = new XBLAuthenticatePayload(new XBLAuthenticatePayload.Properties("RPS", "user.auth.xboxlive.com", "d=" + accessToken), "http://auth.xboxlive.com", "JWT");
        try {
            URL url = ConnectionUtil.urlBuilder("https://user.auth.xboxlive.com/user/authenticate");
            HttpResponse response = ConnectionUtil.jsonPostRequest(url, HttpPayload.fromGson(payload), timeoutValues);
            if (response.getResponseCode() >= 400) {
                return MicrosoftResponse.ofError(response.getResponseCode());
            }
            responseElement = JsonParser.parseString((String)response.getAsString());
        }
        catch (JsonParseException | IOException ex) {
            return MicrosoftResponse.ofException(ex);
        }
        try {
            XBLAuthenticateResponse response = (XBLAuthenticateResponse)Constants.GSON.fromJson(responseElement, XBLAuthenticateResponse.class);
            if (response.getDisplayClaims().getXui().isEmpty()) {
                throw new IllegalStateException("Xui (user hashes) cannot be missing");
            }
            return MicrosoftResponse.ofResponse(response);
        }
        catch (Exception ex) {
            return MicrosoftResponse.ofException(ex);
        }
    }

    public static MicrosoftResponse<XSTSAuthorizeResponse, XSTSAuthorizeErrorResponse> xstsAuthorize(String xblToken, String relyingParty, XBoxResponse.DisplayClaims displayClaims, ConnectionUtil.TimeoutValues timeoutValues) {
        JsonElement responseElement;
        XSTSAuthorizePayload payload = new XSTSAuthorizePayload(new XSTSAuthorizePayload.Properties("RETAIL", Arrays.asList(xblToken)), relyingParty, "JWT");
        try {
            URL url = ConnectionUtil.urlBuilder("https://xsts.auth.xboxlive.com/xsts/authorize");
            String responseString = ConnectionUtil.jsonPostRequest(url, HttpPayload.fromGson(payload), timeoutValues).getAsString();
            responseElement = JsonParser.parseString((String)responseString);
        }
        catch (JsonParseException | IOException ex) {
            return MicrosoftResponse.ofException(ex);
        }
        try {
            List<XBoxResponse.DisplayClaims.Xui> xstsXui;
            JsonObject responseObject = responseElement.getAsJsonObject();
            if (responseObject.has("XErr")) {
                return MicrosoftResponse.ofError((XSTSAuthorizeErrorResponse)Constants.GSON.fromJson((JsonElement)responseObject, XSTSAuthorizeErrorResponse.class));
            }
            XSTSAuthorizeResponse response = (XSTSAuthorizeResponse)Constants.GSON.fromJson((JsonElement)responseObject, XSTSAuthorizeResponse.class);
            List<XBoxResponse.DisplayClaims.Xui> xblXui = displayClaims.getXui();
            if (xblXui.containsAll(xstsXui = response.getDisplayClaims().getXui())) {
                throw new IllegalStateException("Xui (user hashes) do match match");
            }
            return MicrosoftResponse.ofResponse(response);
        }
        catch (Exception ex) {
            return MicrosoftResponse.ofException(ex);
        }
    }

    public static MicrosoftResponse<MinecraftLauncherLoginResponse, Integer> minecraftLaucherLogin(String xstsToken, XBoxResponse.DisplayClaims displayClaims, ConnectionUtil.TimeoutValues timeoutValues) {
        JsonElement responseElement;
        MinecraftLauncherLoginPayload payload = new MinecraftLauncherLoginPayload("XBL3.0 x=" + displayClaims.getXui().get(0).getUhs() + ";" + xstsToken, "PC_LAUNCHER");
        try {
            URL url = ConnectionUtil.urlBuilder("https://api.minecraftservices.com", "launcher/login");
            HttpResponse response = ConnectionUtil.jsonPostRequest(url, HttpPayload.fromGson(payload), timeoutValues);
            if (response.getResponseCode() >= 400) {
                return MicrosoftResponse.ofError(response.getResponseCode());
            }
            responseElement = JsonParser.parseString((String)response.getAsString());
        }
        catch (JsonParseException | IOException ex) {
            return MicrosoftResponse.ofException(ex);
        }
        try {
            MinecraftLauncherLoginResponse response = (MinecraftLauncherLoginResponse)Constants.GSON.fromJson(responseElement, MinecraftLauncherLoginResponse.class);
            return MicrosoftResponse.ofResponse(response);
        }
        catch (Exception ex) {
            return MicrosoftResponse.ofException(ex);
        }
    }

    public static MicrosoftResponse<MinecraftHasPurchasedResponse, Integer> minecraftHasPurchased(String accessToken, UUID launcherClientId, ConnectionUtil.TimeoutValues timeoutValues) {
        JsonElement responseElement;
        try {
            URL url = ConnectionUtil.urlBuilder("https://api.minecraftservices.com", "entitlements/license", Parameters.create().add("requestId", launcherClientId));
            HttpResponse response = ConnectionUtil.bearerAuthorizationJsonGetRequest(url, accessToken, timeoutValues);
            if (response.getResponseCode() >= 400) {
                return MicrosoftResponse.ofError(response.getResponseCode());
            }
            responseElement = JsonParser.parseString((String)response.getAsString());
        }
        catch (JsonParseException | IOException ex) {
            return MicrosoftResponse.ofException(ex);
        }
        try {
            MinecraftHasPurchasedResponse response = (MinecraftHasPurchasedResponse)Constants.GSON.fromJson(responseElement, MinecraftHasPurchasedResponse.class);
            return MicrosoftResponse.ofResponse(response);
        }
        catch (Exception ex) {
            return MicrosoftResponse.ofException(ex);
        }
    }

    public static MicrosoftResponse<MinecraftProfileResponse, Integer> minecraftProfile(String accessToken, ConnectionUtil.TimeoutValues timeoutValues) {
        JsonElement responseElement;
        try {
            URL url = ConnectionUtil.urlBuilder("https://api.minecraftservices.com", "minecraft/profile");
            HttpResponse response = ConnectionUtil.bearerAuthorizationJsonGetRequest(url, accessToken, timeoutValues);
            if (response.getResponseCode() >= 400) {
                return MicrosoftResponse.ofError(response.getResponseCode());
            }
            responseElement = JsonParser.parseString((String)response.getAsString());
        }
        catch (JsonParseException | IOException ex) {
            return MicrosoftResponse.ofException(ex);
        }
        try {
            MinecraftProfileResponse response = (MinecraftProfileResponse)Constants.GSON.fromJson(responseElement, MinecraftProfileResponse.class);
            return MicrosoftResponse.ofResponse(response);
        }
        catch (Exception ex) {
            return MicrosoftResponse.ofException(ex);
        }
    }

    public static MicrosoftResponse<XBoxProfileResponse, Integer> xboxProfileSettings(String xstsToken, XBoxResponse.DisplayClaims displayClaims, ConnectionUtil.TimeoutValues timeoutValues) {
        JsonElement responseElement;
        String authorization = "XBL3.0 x=" + displayClaims.getXui().get(0).getUhs() + ";" + xstsToken;
        try {
            URL url = ConnectionUtil.urlBuilder("https://profile.xboxlive.com/users/me/profile/settings", Parameters.create().add("settings", "GameDisplayName,AppDisplayName,AppDisplayPicRaw,GameDisplayPicRaw,PublicGamerpic,Gamerscore,Gamertag,ModernGamertag,ModernGamertagSuffix,UniqueModernGamertag,AccountTier,XboxOneRep,Location,Bio,Watermarks,RealName,RealNameOverride,IsQuarantined"));
            HttpResponse response = ConnectionUtil.authorizationJsonGetRequest(url, authorization, urlConnection -> urlConnection.addRequestProperty("x-xbl-contract-version", "3"), timeoutValues);
            if (response.getResponseCode() >= 400) {
                return MicrosoftResponse.ofError(response.getResponseCode());
            }
            responseElement = JsonParser.parseString((String)response.getAsString());
        }
        catch (JsonParseException | IOException ex) {
            return MicrosoftResponse.ofException(ex);
        }
        try {
            XBoxProfileResponse response = (XBoxProfileResponse)Constants.GSON.fromJson(responseElement, XBoxProfileResponse.class);
            return MicrosoftResponse.ofResponse(response);
        }
        catch (Exception ex) {
            return MicrosoftResponse.ofException(ex);
        }
    }
}

