/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftAuthenticationFile;
import java.util.UUID;

public class MicrosoftAuthenticationFileSerializer {
    public static JsonObject serialize(MicrosoftAuthenticationFile authFile) {
        JsonObject object = new JsonObject();
        JsonObject clientIdObject = new JsonObject();
        clientIdObject.addProperty("most", (Number)authFile.getClientId().getMostSignificantBits());
        clientIdObject.addProperty("least", (Number)authFile.getClientId().getLeastSignificantBits());
        object.add("clientId", (JsonElement)clientIdObject);
        object.addProperty("refreshToken", authFile.getRefreshToken());
        JsonObject extraPropertiesObject = new JsonObject();
        authFile.getExtraProperties().forEach((arg_0, arg_1) -> ((JsonObject)extraPropertiesObject).addProperty(arg_0, arg_1));
        object.add("extraProperties", (JsonElement)extraPropertiesObject);
        return object;
    }

    public static MicrosoftAuthenticationFile deserialize(JsonObject object) {
        JsonObject clientIdObject = object.getAsJsonObject("clientId");
        long clientIdMost = clientIdObject.get("most").getAsLong();
        long clientIdLeast = clientIdObject.get("least").getAsLong();
        UUID clientId = new UUID(clientIdMost, clientIdLeast);
        String refreshToken = object.get("refreshToken").getAsString();
        MicrosoftAuthenticationFile file = new MicrosoftAuthenticationFile(clientId, refreshToken);
        JsonObject extraPropertiesObject = object.getAsJsonObject("extraProperties");
        if (extraPropertiesObject != null) {
            extraPropertiesObject.keySet().forEach(key -> file.getExtraProperties().put((String)key, extraPropertiesObject.get(key).getAsString()));
        }
        return file;
    }
}

