/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft;

import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.Authenticator;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.LoginState;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.AzureApplication;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftAuthenticationException;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftAuthenticationFile;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftLoginResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftLoginRoutine;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.OAuthErrorResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.OAuthTokenResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.service.MicrosoftResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.service.MicrosoftService;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.ConnectionUtil;
import java.util.Optional;
import java.util.UUID;

public class MicrosoftAuthentication {
    public static MicrosoftAuthenticationFile createAuthenticationFile(Optional<AzureApplication> customAzureApplication, String authorizationCode, ConnectionUtil.TimeoutValues timeoutValues) throws MicrosoftAuthenticationException {
        MicrosoftResponse<OAuthTokenResponse, OAuthErrorResponse> microsoftResponse;
        if (customAzureApplication.isPresent()) {
            AzureApplication azureApplication = customAzureApplication.get();
            String clientId = azureApplication.clientId();
            String redirectUrl = azureApplication.redirectUrl();
            String clientSecret = azureApplication.clientSecret();
            microsoftResponse = MicrosoftService.oAuthTokenFromCode(clientId, redirectUrl, clientSecret, authorizationCode, timeoutValues);
        } else {
            microsoftResponse = MicrosoftService.oAuthTokenFromCode(authorizationCode, timeoutValues);
        }
        if (microsoftResponse.hasException()) {
            throw new MicrosoftAuthenticationException("Cannot get oAuth token", microsoftResponse.getException().get());
        }
        if (microsoftResponse.hasErrorResponse()) {
            throw new MicrosoftAuthenticationException("Cannot get oAuth token because: " + microsoftResponse.getErrorResponse().get());
        }
        OAuthTokenResponse response = microsoftResponse.getResponse().get();
        return new MicrosoftAuthenticationFile(UUID.randomUUID(), response.getRefreshToken());
    }

    public static MicrosoftLoginResponse authenticate(Optional<AzureApplication> customAzureApplication, boolean retrieveXBoxProfile, MicrosoftAuthenticationFile file, ConnectionUtil.TimeoutValues timeoutValues, Authenticator.LoginStateCallback callback) {
        callback.call(LoginState.LOGIN_MICOSOFT);
        if (customAzureApplication.isPresent()) {
            AzureApplication azureApplication = customAzureApplication.get();
            String clientId = azureApplication.clientId();
            String redirectUrl = azureApplication.redirectUrl();
            String clientSecret = azureApplication.clientSecret();
            return MicrosoftLoginRoutine.loginWithRefreshToken(clientId, redirectUrl, clientSecret, retrieveXBoxProfile, file.getRefreshToken(), file.getClientId(), timeoutValues, callback);
        }
        return MicrosoftLoginRoutine.loginWithRefreshToken(retrieveXBoxProfile, file.getRefreshToken(), file.getClientId(), timeoutValues, callback);
    }
}

