/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen.widget;

import com.mojang.authlib.GameProfile;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.util.WidgetUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PlayerIconWidget
extends AbstractWidget
implements PerspectiveRenderable,
TooltipRenderable {
    private final Minecraft minecraft = Minecraft.getInstance();
    private GameProfile profile;

    public PlayerIconWidget(int x, int y, int size, GameProfile profile) {
        super(x, y, size, size, CommonComponents.EMPTY);
        this.profile = profile;
    }

    public void setProfile(GameProfile profile) {
        this.profile = profile;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.profile != null) {
            this.renderBehind(guiGraphics, mouseX, mouseY, partialTick);
            this.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
            WidgetUtil.renderCustomTooltipForWidget((TooltipRenderable)this, (GuiGraphics)guiGraphics, (int)mouseX, (int)mouseY, (float)partialTick);
        }
    }

    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation skin = this.minecraft.getSkinManager().getInsecureSkin(this.profile).texture();
        PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (ResourceLocation)skin, (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (boolean)false, (boolean)false);
    }

    public void renderBehind(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHovered) {
            guiGraphics.renderTooltip(this.minecraft.font, List.of(Component.literal((String)this.profile.getName())), Optional.empty(), mouseX, mouseY);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput element) {
        this.defaultButtonNarrationText(element);
    }

    public void playDownSound(SoundManager pHandler) {
    }
}

