/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen.list;

import info.u_team.oauth_account_manager.screen.list.AbstractAccountSelectionEntry;
import info.u_team.oauth_account_manager.screen.list.AccountSelectionEntry;
import info.u_team.oauth_account_manager.screen.list.LaunchedAccountSelectionEntry;
import info.u_team.oauth_account_manager.util.MinecraftAccounts;
import info.u_team.u_team_core.gui.elements.ScrollableList;
import java.util.UUID;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.Screen;
import org.apache.commons.lang3.StringUtils;

public class AccountSelectionList
extends ScrollableList<AbstractAccountSelectionEntry> {
    private final Screen ourScreen;

    public AccountSelectionList(Screen ourScreen) {
        super(0, 0, 0, 0, 36, 0);
        this.ourScreen = ourScreen;
    }

    public int getRowWidth() {
        return 305;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 154;
    }

    public void loadEntries() {
        UUID selectedUUID = this.getSelected() != null ? ((AbstractAccountSelectionEntry)this.getSelected()).getUuid() : null;
        this.clearEntries();
        LaunchedAccountSelectionEntry launchedEntry = new LaunchedAccountSelectionEntry(this.ourScreen, this);
        this.addEntry((AbstractSelectionList.Entry)launchedEntry);
        if (launchedEntry.getUuid().equals(selectedUUID)) {
            this.setSelected((AbstractSelectionList.Entry)launchedEntry);
        }
        MinecraftAccounts.getAccountUUIDs().stream().map(uuid -> new AccountSelectionEntry(this.ourScreen, this, (UUID)uuid, MinecraftAccounts.getGameProfile(uuid))).sorted((a, b) -> StringUtils.compare((String)a.getProfile().getName(), (String)b.getProfile().getName())).forEach(entry -> {
            this.addEntry((AbstractSelectionList.Entry)entry);
            if (entry.getUuid().equals(selectedUUID)) {
                this.setSelected((AbstractSelectionList.Entry)entry);
            }
        });
        this.setScrollAmount(this.getScrollAmount());
    }

    public void useSelectedEntry() {
        AbstractAccountSelectionEntry entry = (AbstractAccountSelectionEntry)this.getSelected();
        if (entry != null) {
            entry.useEntry();
        }
    }

    public void deleteSelectedEntry() {
        AbstractSelectionList.Entry entry = this.getSelected();
        if (entry instanceof AccountSelectionEntry) {
            AccountSelectionEntry entry2 = (AccountSelectionEntry)entry;
            this.removeEntry((AbstractSelectionList.Entry)entry2);
            MinecraftAccounts.removeAccount(entry2.getUuid());
        }
    }
}

