/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen.list;

import com.mojang.authlib.GameProfile;
import info.u_team.oauth_account_manager.screen.list.AccountSelectionList;
import info.u_team.u_team_core.gui.elements.ScrollableListEntry;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractAccountSelectionEntry
extends ScrollableListEntry<AbstractAccountSelectionEntry> {
    protected final Screen ourScreen;
    private final AccountSelectionList selectionList;
    private final UUID uuid;
    private final GameProfile profile;
    protected final boolean currentlyUsed;
    private long lastClickTime;

    public AbstractAccountSelectionEntry(Screen ourScreen, AccountSelectionList selectionList, UUID uuid, GameProfile profile) {
        this.ourScreen = ourScreen;
        this.selectionList = selectionList;
        this.uuid = uuid;
        this.profile = profile;
        this.currentlyUsed = uuid.equals(this.minecraft.getUser().getProfileId());
    }

    public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
        ResourceLocation skin = this.minecraft.getSkinManager().getInsecureSkin(this.profile).texture();
        PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (ResourceLocation)skin, (int)left, (int)top, (int)32, (boolean)false, (boolean)false);
        guiGraphics.drawString(this.minecraft.font, (Component)this.getTitleName(), left + 35, top + 1, 0xFFFFFF, false);
        guiGraphics.drawString(this.minecraft.font, this.uuid.toString(), left + 35, top + 12, 0x808080, false);
        if (hovered && this.currentlyUsed) {
            this.ourScreen.setTooltipForNextRenderPass(this.minecraft.font.split((FormattedText)Component.translatable((String)"screen.oauthaccountmanager.accounts.list.used.tooltip"), 175));
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335) {
            this.playClickSound();
            this.selectionList.useSelectedEntry();
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (Util.getMillis() - this.lastClickTime < 250L) {
            this.playClickSound();
            this.selectionList.useSelectedEntry();
            return true;
        }
        this.lastClickTime = Util.getMillis();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void playClickSound() {
        this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public Component getNarration() {
        return Component.literal((String)this.profile.getName());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    protected abstract void useEntry();

    protected MutableComponent getTitleName() {
        return Component.literal((String)this.profile.getName()).withStyle(style -> style.withColor(this.currentlyUsed ? 0x55FF55 : 0xFFFFFF).withItalic(Boolean.valueOf(false)));
    }
}

