/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.util.UndashedUuid;
import info.u_team.oauth_account_manager.OAuthAccountManagerReference;
import info.u_team.oauth_account_manager.screen.CommonWaitingScreen;
import info.u_team.oauth_account_manager.screen.widget.PlayerIconWidget;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationException;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.Authenticator;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.LoginState;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.User;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.XBoxProfile;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.SimpleMinecraftAuthentication;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.result.AuthenticationResult;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.util.AuthenticationFutureUtil;
import info.u_team.oauth_account_manager.util.LoadedAccount;
import info.u_team.oauth_account_manager.util.MinecraftAccounts;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class AccountLoginScreen
extends CommonWaitingScreen {
    private PlayerIconWidget playerIconWidget;

    public AccountLoginScreen(Screen lastScreen) {
        super(lastScreen, lastScreen, (Component)Component.translatable((String)"screen.oauthaccountmanager.account_login.title"));
    }

    @Override
    protected void init() {
        super.init();
        this.setInformationMessage(this.getLoginStateComponent(LoginState.INITAL_FILE));
        this.spinnerWidget.setTooltip(Tooltip.create((Component)Component.translatable((String)"screen.oauthaccountmanager.account_login.spinner.tooltip.logging")));
        this.playerIconWidget = (PlayerIconWidget)this.addRenderableWidget((GuiEventListener)new PlayerIconWidget(this.width / 2 - 32, this.height / 2 - 32, 64, null));
    }

    @Override
    protected void repositionElements() {
        GameProfile profile = this.playerIconWidget.getProfile();
        super.repositionElements();
        this.playerIconWidget.setProfile(profile);
    }

    private Component getLoginStateComponent(LoginState state) {
        return Component.translatable((String)(switch (state) {
            default -> throw new MatchException(null, null);
            case LoginState.INITAL_FILE -> "screen.oauthaccountmanager.account_login.login_state_info.inital_file";
            case LoginState.LOGIN_MICOSOFT -> "screen.oauthaccountmanager.account_login.login_state_info.login_microsoft";
            case LoginState.XBL_TOKEN -> "screen.oauthaccountmanager.account_login.login_state_info.xbl_token";
            case LoginState.XSTS_TOKEN -> "screen.oauthaccountmanager.account_login.login_state_info.xsts_token";
            case LoginState.ACCESS_TOKEN -> "screen.oauthaccountmanager.account_login.login_state_info.access_token";
            case LoginState.ENTITLEMENT -> "screen.oauthaccountmanager.account_login.login_state_info.entitlement";
            case LoginState.PROFILE -> "screen.oauthaccountmanager.account_login.login_state_info.profile";
            case LoginState.XBOX_PROFILE -> "screen.oauthaccountmanager.account_login.login_state_info.xbox_profile";
        }));
    }

    public void login(Optional<UUID> accountUUID, Supplier<AuthenticationResult> authenticationResult, Consumer<AccountLoginScreen> callback) {
        this.createWaitingThread(() -> {
            UUID uuid2;
            Authenticator authenticator = ((AuthenticationResult)authenticationResult.get()).buildAuthenticator(true);
            try {
                AuthenticationFutureUtil.runAuthentication(SimpleMinecraftAuthentication.getExecutor(), () -> {
                    authenticator.run(state -> MinecraftExecutor.executeOnMainThread(() -> this.setInformationMessage(this.getLoginStateComponent(state))));
                    return null;
                }, 300, true);
            }
            catch (AuthenticationException ex) {
                if (!(ex.getCause() instanceof InterruptedException)) {
                    MinecraftExecutor.executeOnMainThread(() -> this.setFinalMessage((Component)Component.translatable((String)"screen.oauthaccountmanager.account_login.message.error", (Object[])new Object[]{ex.getLocalizedMessage()})));
                    OAuthAccountManagerReference.LOGGER.warn("Authentication with minecraft services didn't complete sucessfully", (Throwable)ex);
                }
                accountUUID.ifPresent(uuid -> {
                    if (authenticator.getResultFile() != null) {
                        MinecraftAccounts.updateAuthenticationFile(uuid, authenticator.getResultFile());
                    }
                });
                return;
            }
            User user = authenticator.getUser().orElseThrow(AssertionError::new);
            XBoxProfile xboxProfile = authenticator.getXBoxProfile().orElseThrow(AssertionError::new);
            try {
                uuid2 = UndashedUuid.fromStringLenient((String)user.uuid());
                if (accountUUID.isPresent() && !((UUID)accountUUID.get()).equals(uuid2)) {
                    throw new IllegalArgumentException("UUID returned from minecraft services did not match existing uuid for that account");
                }
            }
            catch (IllegalArgumentException ex) {
                MinecraftExecutor.executeOnMainThread(() -> this.setFinalMessage((Component)Component.translatable((String)"screen.oauthaccountmanager.account_login.message.error", (Object[])new Object[]{ex.getLocalizedMessage()})));
                OAuthAccountManagerReference.LOGGER.error("Cannot add minecraft account", (Throwable)ex);
                return;
            }
            GameProfile profile = this.minecraft.getMinecraftSessionService().fetchProfile(uuid2, true).profile();
            MinecraftAccounts.addAccount(uuid2, authenticator.getResultFile(), profile, new LoadedAccount(user, xboxProfile));
            MinecraftExecutor.executeOnMainThread(() -> {
                this.playerIconWidget.setProfile(profile);
                this.setFinalMessage((Component)Component.translatable((String)"screen.oauthaccountmanager.account_login.message.success", (Object[])new Object[]{authenticator.getUser().get().name()}));
                if (callback != null) {
                    callback.accept(this);
                }
            });
        });
    }
}

