/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen;

import info.u_team.oauth_account_manager.util.AuthenticationUtil;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.screen.UScreen;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.EqualSpacingLayout;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class AccountCheckValidScreen
extends UScreen {
    private final Screen lastScreen;
    private final Runnable retryCallback;
    private final Runnable validCallback;
    private CompletableFuture<?> future;
    private MultiLineTextWidget messageWidget;
    private UButton retryButton;
    private UButton cancelButton;

    public AccountCheckValidScreen(Screen lastScreen, Runnable retryCallback, Runnable validCallback) {
        super((Component)Component.translatable((String)"screen.oauthaccountmanager.check_account_valid.title"));
        this.lastScreen = lastScreen;
        this.retryCallback = retryCallback;
        this.validCallback = validCallback;
    }

    protected void init() {
        super.init();
        this.messageWidget = (MultiLineTextWidget)this.addRenderableWidget((GuiEventListener)new MultiLineTextWidget(0, this.height / 2 - 20, CommonComponents.EMPTY, this.font).setMaxWidth(this.width - 50).setCentered(true));
        this.setInformationMessage((Component)Component.translatable((String)"screen.oauthaccountmanager.check_account_valid.message.checking"));
        this.retryButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 100, 20, (Component)Component.translatable((String)"screen.oauthaccountmanager.check_account_valid.button.retry")));
        this.retryButton.setPressable(this.retryCallback::run);
        this.retryButton.active = false;
        this.cancelButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 100, 20, CommonComponents.GUI_CANCEL));
        this.cancelButton.setPressable(this::cancelChecking);
        EqualSpacingLayout layout = new EqualSpacingLayout(205, 20, EqualSpacingLayout.Orientation.HORIZONTAL);
        layout.addChild((LayoutElement)this.retryButton);
        layout.addChild((LayoutElement)this.cancelButton);
        layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)layout, (int)0, (int)(this.height - 64), (int)this.width, (int)64);
    }

    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public void onClose() {
        this.cancelChecking();
    }

    protected void repositionElements() {
        Component messageWidgetMessage = this.messageWidget.getMessage();
        boolean retryButtonActive = this.retryButton.active;
        super.repositionElements();
        this.setInformationMessage(messageWidgetMessage);
        this.retryButton.active = retryButtonActive;
    }

    protected void setInformationMessage(Component component) {
        this.messageWidget.setMessage(component);
        this.messageWidget.setX(this.width / 2 - this.messageWidget.getWidth() / 2);
    }

    protected void cancelChecking() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.minecraft.setScreen(this.lastScreen);
    }

    public void checkAccount(String accessToken) {
        this.future = AuthenticationUtil.isAccessTokenValid(accessToken).orTimeout(30L, TimeUnit.SECONDS).thenAccept(valid -> MinecraftExecutor.executeOnMainThread(() -> {
            if (valid.booleanValue()) {
                this.validCallback.run();
            } else {
                this.retryButton.active = true;
                this.setInformationMessage((Component)Component.translatable((String)"screen.oauthaccountmanager.check_account_valid.message.invalid"));
            }
        }));
    }
}

