/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import info.u_team.oauth_account_manager.OAuthAccountManagerReference;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationFile;
import info.u_team.oauth_account_manager.util.LoadedAccount;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;

public class MinecraftAccounts {
    private static final Map<UUID, AuthenticationFile> ACCOUNTS = new HashMap<UUID, AuthenticationFile>();
    private static final Map<UUID, GameProfile> LOADED_GAME_PROFILES = new HashMap<UUID, GameProfile>();
    private static final Map<UUID, LoadedAccount> LOADED_ACCOUNTS = new HashMap<UUID, LoadedAccount>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path ACCOUNT_DIRECTORY = Minecraft.getInstance().gameDirectory.toPath().resolve(".oauth-account-manager");
    private static final Path ACCOUNT_FILE = ACCOUNT_DIRECTORY.resolve("accounts.mcoauth");

    private static void load() throws IOException {
        JsonObject json;
        MinecraftAccounts.ensureDirectoryExists();
        if (Files.notExists(ACCOUNT_FILE, new LinkOption[0])) {
            MinecraftAccounts.save();
        }
        try (BufferedReader reader = Files.newBufferedReader(ACCOUNT_FILE, StandardCharsets.UTF_8);){
            json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        for (Map.Entry entry : json.entrySet()) {
            ACCOUNTS.put(UUID.fromString((String)entry.getKey()), AuthenticationFile.readCompressed(Base64.getDecoder().decode(((JsonElement)entry.getValue()).getAsString())));
        }
        for (UUID uuid : ACCOUNTS.keySet()) {
            GameProfile profile = Minecraft.getInstance().getMinecraftSessionService().fetchProfile(uuid, true).profile();
            LOADED_GAME_PROFILES.put(uuid, profile);
        }
        OAuthAccountManagerReference.LOGGER.info("Loaded {} account" + (ACCOUNTS.size() != 1 ? "s" : "") + " ({})", (Object)ACCOUNTS.size(), (Object)LOADED_GAME_PROFILES.values().stream().map(GameProfile::getName).collect(Collectors.joining(", ")));
    }

    private static void save() throws IOException {
        MinecraftAccounts.ensureDirectoryExists();
        JsonObject json = new JsonObject();
        for (Map.Entry<UUID, AuthenticationFile> entry : ACCOUNTS.entrySet()) {
            json.addProperty(entry.getKey().toString(), Base64.getEncoder().encodeToString(entry.getValue().writeCompressed()));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(ACCOUNT_FILE, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
    }

    public static Future<?> enqueueLoad() {
        return Util.nonCriticalIoPool().submit(() -> {
            try {
                MinecraftAccounts.load();
            }
            catch (IOException ex) {
                OAuthAccountManagerReference.LOGGER.error("Cannot load minecraft accounts", (Throwable)ex);
            }
        });
    }

    public static Future<?> enqueueSave() {
        return Util.nonCriticalIoPool().submit(() -> {
            try {
                MinecraftAccounts.save();
            }
            catch (IOException ex) {
                OAuthAccountManagerReference.LOGGER.error("Cannot save minecraft accounts", (Throwable)ex);
            }
        });
    }

    private static void ensureDirectoryExists() throws IOException {
        Files.createDirectories(ACCOUNT_DIRECTORY, new FileAttribute[0]);
    }

    public static void addAccount(UUID uuid, AuthenticationFile file, GameProfile profile, LoadedAccount account) {
        ACCOUNTS.put(uuid, file);
        LOADED_GAME_PROFILES.put(uuid, profile);
        LOADED_ACCOUNTS.put(uuid, account);
        MinecraftAccounts.enqueueSave();
    }

    public static void removeAccount(UUID uuid) {
        ACCOUNTS.remove(uuid);
        LOADED_GAME_PROFILES.remove(uuid);
        LOADED_ACCOUNTS.remove(uuid);
        MinecraftAccounts.enqueueSave();
    }

    public static void updateAuthenticationFile(UUID uuid, AuthenticationFile file) {
        ACCOUNTS.put(uuid, file);
        MinecraftAccounts.enqueueSave();
    }

    public static Set<UUID> getAccountUUIDs() {
        return ACCOUNTS.keySet();
    }

    public static AuthenticationFile getAccount(UUID uuid) {
        return ACCOUNTS.get(uuid);
    }

    public static LoadedAccount getLoadedAccount(UUID uuid) {
        return LOADED_ACCOUNTS.get(uuid);
    }

    public static GameProfile getGameProfile(UUID uuid) {
        return LOADED_GAME_PROFILES.get(uuid);
    }

    public static boolean isLoaded(UUID uuid) {
        return LOADED_ACCOUNTS.containsKey(uuid);
    }
}

