/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.method;

import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationException;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationFile;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.Authenticator;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.method.AbstractAuthenticationMethod;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.method.WebAuthentication;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.result.AuthenticationResult;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.result.FileAuthenticationResult;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.util.UnclosableInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;

public class HeadlessWebAuthentication
extends AbstractAuthenticationMethod {
    private final BufferedReader reader;
    private final String clientId = "78590d64-3549-4c5f-9ef5-add1e816fed1";
    private final String redirectUrl;

    public HeadlessWebAuthentication(PrintStream out, InputStream in, ExecutorService executor) {
        super(out, executor);
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new UnclosableInputStream(in), StandardCharsets.UTF_8));
        this.redirectUrl = WebAuthentication.EXISTING_REDIRECT_URL;
    }

    @Override
    public AuthenticationResult existingAuthentication(AuthenticationFile file) {
        return new FileAuthenticationResult(file, "78590d64-3549-4c5f-9ef5-add1e816fed1", this.redirectUrl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AuthenticationResult runInitalAuthentication() throws IOException, AuthenticationException {
        URL loginUrl = Authenticator.microsoftLogin("78590d64-3549-4c5f-9ef5-add1e816fed1", this.redirectUrl);
        this.loginUrlCallback.accept(loginUrl);
        this.out.println("Open the following link and log into your microsoft account. Paste the code parameter of the returned url.");
        this.out.println("Code should look like this: M.R3_BL2.00000000-0000-0000-0000-000000000000");
        this.out.println(loginUrl);
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)(this.timeout * 1000) && !this.reader.ready()) {
            HeadlessWebAuthentication headlessWebAuthentication = this;
            synchronized (headlessWebAuthentication) {
                try {
                    this.wait(10L);
                }
                catch (InterruptedException ex) {
                    return null;
                }
            }
        }
        if (this.reader.ready()) {
            String authorizationCode = this.reader.readLine();
            Authenticator authenticator = Authenticator.ofMicrosoft(authorizationCode).customAzureApplication("78590d64-3549-4c5f-9ef5-add1e816fed1", this.redirectUrl).build();
            authenticator.run();
            return new FileAuthenticationResult(authenticator.getResultFile(), "78590d64-3549-4c5f-9ef5-add1e816fed1", this.redirectUrl, null);
        }
        return null;
    }

    @Override
    protected void finishInitalAuthentication() throws Exception {
        this.reader.close();
    }
}

