/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.service;

import java.util.Optional;

public class MicrosoftResponse<T, E> {
    private final Optional<T> response;
    private final Optional<E> errorResponse;
    private final Optional<Throwable> exception;

    public static <T, E> MicrosoftResponse<T, E> ofResponse(T response) {
        return new MicrosoftResponse(Optional.ofNullable(response), Optional.empty(), Optional.empty());
    }

    public static <T, E> MicrosoftResponse<T, E> ofError(E error) {
        return new MicrosoftResponse(Optional.empty(), Optional.ofNullable(error), Optional.empty());
    }

    public static <T, E> MicrosoftResponse<T, E> ofException(Throwable exception) {
        return new MicrosoftResponse(Optional.empty(), Optional.empty(), Optional.ofNullable(exception));
    }

    private MicrosoftResponse(Optional<T> response, Optional<E> errorResponse, Optional<Throwable> exception) {
        this.response = response;
        this.errorResponse = errorResponse;
        this.exception = exception;
    }

    public boolean hasSucessfulResponse() {
        return this.response.isPresent();
    }

    public Optional<T> getResponse() {
        return this.response;
    }

    public boolean hasErrorResponse() {
        return this.errorResponse.isPresent();
    }

    public Optional<E> getErrorResponse() {
        return this.errorResponse;
    }

    public boolean hasException() {
        return this.exception.isPresent();
    }

    public Optional<Throwable> getException() {
        return this.exception;
    }
}

