/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.Authenticator;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.LoginState;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.User;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.XBoxProfile;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftAuthenticationException;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftLoginResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.MinecraftHasPurchasedResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.MinecraftLauncherLoginResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.MinecraftProfileResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.OAuthErrorResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.OAuthTokenResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.XBLAuthenticateResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.XBoxProfileResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.XSTSAuthorizeErrorResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.api.XSTSAuthorizeResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.service.MicrosoftResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.service.MicrosoftService;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.ConnectionUtil;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.ParseUtil;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class MicrosoftLoginRoutine {
    public static MicrosoftLoginResponse loginWithAuthCode(boolean retrieveXBoxProfile, String authCode, UUID launcherClientId, ConnectionUtil.TimeoutValues timeoutValues, Authenticator.LoginStateCallback callback) {
        return MicrosoftLoginRoutine.login(MicrosoftService.oAuthTokenFromCode(authCode, timeoutValues), retrieveXBoxProfile, launcherClientId, timeoutValues, callback);
    }

    public static MicrosoftLoginResponse loginWithAuthCode(String clientId, String redirectUrl, boolean retrieveXBoxProfile, String authCode, UUID launcherClientId, ConnectionUtil.TimeoutValues timeoutValues, Authenticator.LoginStateCallback callback) {
        return MicrosoftLoginRoutine.login(MicrosoftService.oAuthTokenFromCode(clientId, redirectUrl, authCode, timeoutValues), retrieveXBoxProfile, launcherClientId, timeoutValues, callback);
    }

    public static MicrosoftLoginResponse loginWithAuthCode(String clientId, String redirectUrl, String clientSecret, boolean retrieveXBoxProfile, String authCode, UUID launcherClientId, ConnectionUtil.TimeoutValues timeoutValues, Authenticator.LoginStateCallback callback) {
        return MicrosoftLoginRoutine.login(MicrosoftService.oAuthTokenFromCode(clientId, redirectUrl, clientSecret, authCode, timeoutValues), retrieveXBoxProfile, launcherClientId, timeoutValues, callback);
    }

    public static MicrosoftLoginResponse loginWithRefreshToken(boolean retrieveXBoxProfile, String refreshToken, UUID launcherClientId, ConnectionUtil.TimeoutValues timeoutValues, Authenticator.LoginStateCallback callback) {
        return MicrosoftLoginRoutine.login(MicrosoftService.oAuthTokenFromRefreshToken(refreshToken, timeoutValues), retrieveXBoxProfile, launcherClientId, timeoutValues, callback);
    }

    public static MicrosoftLoginResponse loginWithRefreshToken(String clientId, String redirectUrl, boolean retrieveXBoxProfile, String refreshToken, UUID launcherClientId, ConnectionUtil.TimeoutValues timeoutValues, Authenticator.LoginStateCallback callback) {
        return MicrosoftLoginRoutine.login(MicrosoftService.oAuthTokenFromRefreshToken(clientId, redirectUrl, refreshToken, timeoutValues), retrieveXBoxProfile, launcherClientId, timeoutValues, callback);
    }

    public static MicrosoftLoginResponse loginWithRefreshToken(String clientId, String redirectUrl, String clientSecret, boolean retrieveXBoxProfile, String refreshToken, UUID launcherClientId, ConnectionUtil.TimeoutValues timeoutValues, Authenticator.LoginStateCallback callback) {
        return MicrosoftLoginRoutine.login(MicrosoftService.oAuthTokenFromRefreshToken(clientId, redirectUrl, clientSecret, refreshToken, timeoutValues), retrieveXBoxProfile, launcherClientId, timeoutValues, callback);
    }

    private static MicrosoftLoginResponse login(MicrosoftResponse<OAuthTokenResponse, OAuthErrorResponse> oAuthResponse, boolean retrieveXBoxProfile, UUID launcherClientId, ConnectionUtil.TimeoutValues timeoutValues, Authenticator.LoginStateCallback callback) {
        Optional<XBoxProfile> xBoxProfile;
        String xuid;
        if (oAuthResponse.hasException()) {
            return MicrosoftLoginRoutine.exception("Cannot get oAuth token", oAuthResponse.getException().get(), Optional.empty());
        }
        if (oAuthResponse.hasErrorResponse()) {
            return MicrosoftLoginRoutine.exception("Cannot get oAuth token because: " + oAuthResponse.getErrorResponse().get(), Optional.empty());
        }
        OAuthTokenResponse oAuth = MicrosoftLoginRoutine.successResponse(oAuthResponse);
        callback.call(LoginState.XBL_TOKEN);
        MicrosoftResponse<XBLAuthenticateResponse, Integer> xblResponse = MicrosoftService.xblAuthenticate(oAuth.getAccessToken(), timeoutValues);
        if (xblResponse.hasException()) {
            return MicrosoftLoginRoutine.exception("Cannot authenticate with xbl", xblResponse.getException().get(), oAuth);
        }
        if (xblResponse.hasErrorResponse()) {
            return MicrosoftLoginRoutine.exception("Cannot authenticate with xbl because the service returned http code " + xblResponse.getErrorResponse().get(), oAuth);
        }
        XBLAuthenticateResponse xbl = MicrosoftLoginRoutine.successResponse(xblResponse);
        callback.call(LoginState.XSTS_TOKEN);
        MicrosoftResponse<XSTSAuthorizeResponse, XSTSAuthorizeErrorResponse> minecraftXstsResponse = MicrosoftService.xstsAuthorize(xbl.getToken(), "rp://api.minecraftservices.com/", xbl.getDisplayClaims(), timeoutValues);
        if (minecraftXstsResponse.hasException()) {
            return MicrosoftLoginRoutine.exception("Cannot authorize with xsts for minecraft services", minecraftXstsResponse.getException().get(), oAuth);
        }
        if (minecraftXstsResponse.hasErrorResponse()) {
            return MicrosoftLoginRoutine.exception("Cannot authorize with xsts for minecraft services because: " + minecraftXstsResponse.getErrorResponse().get(), oAuth);
        }
        XSTSAuthorizeResponse minecraftXsts = MicrosoftLoginRoutine.successResponse(minecraftXstsResponse);
        callback.call(LoginState.ACCESS_TOKEN);
        MicrosoftResponse<MinecraftLauncherLoginResponse, Integer> minecraftLoginResponse = MicrosoftService.minecraftLaucherLogin(minecraftXsts.getToken(), minecraftXsts.getDisplayClaims(), timeoutValues);
        if (minecraftLoginResponse.hasException()) {
            return MicrosoftLoginRoutine.exception("Cannot login into minecraft with xbox", minecraftLoginResponse.getException().get(), oAuth);
        }
        if (minecraftLoginResponse.hasErrorResponse()) {
            return MicrosoftLoginRoutine.exception("Cannot login into minecraft with xbox because the service returned http code " + minecraftLoginResponse.getErrorResponse().get(), oAuth);
        }
        MinecraftLauncherLoginResponse minecraftLogin = MicrosoftLoginRoutine.successResponse(minecraftLoginResponse);
        callback.call(LoginState.ENTITLEMENT);
        MicrosoftResponse<MinecraftHasPurchasedResponse, Integer> minecraftHasPurchasedResponse = MicrosoftService.minecraftHasPurchased(minecraftLogin.getAccessToken(), launcherClientId, timeoutValues);
        if (minecraftHasPurchasedResponse.hasException()) {
            return MicrosoftLoginRoutine.exception("Cannot get purchase data for minecraft", minecraftHasPurchasedResponse.getException().get(), oAuth);
        }
        if (minecraftHasPurchasedResponse.hasErrorResponse()) {
            return MicrosoftLoginRoutine.exception("Cannot get purchase data for minecraft because the service returned http code " + minecraftHasPurchasedResponse.getErrorResponse().get(), oAuth);
        }
        MinecraftHasPurchasedResponse minecraftHasPurchased = MicrosoftLoginRoutine.successResponse(minecraftHasPurchasedResponse);
        if (minecraftHasPurchased.getItems().size() == 0) {
            return MicrosoftLoginRoutine.exception("This account does not have bought minecraft", oAuth);
        }
        callback.call(LoginState.PROFILE);
        MicrosoftResponse<MinecraftProfileResponse, Integer> minecraftProfileResponse = MicrosoftService.minecraftProfile(minecraftLogin.getAccessToken(), timeoutValues);
        if (minecraftProfileResponse.hasException()) {
            return MicrosoftLoginRoutine.exception("Cannot get minecraft profile data", minecraftProfileResponse.getException().get(), oAuth);
        }
        if (minecraftProfileResponse.hasErrorResponse()) {
            return MicrosoftLoginRoutine.exception("Cannot get minecraft profile data because the service returned http code " + minecraftProfileResponse.getErrorResponse().get(), oAuth);
        }
        MinecraftProfileResponse minecraftProfile = MicrosoftLoginRoutine.successResponse(minecraftProfileResponse);
        try {
            String jwt = ParseUtil.decodeJWT(minecraftLogin.getAccessToken());
            JsonObject payload = JsonParser.parseString((String)jwt).getAsJsonObject();
            xuid = payload.get("xuid").getAsString();
        }
        catch (Exception ex) {
            return MicrosoftLoginRoutine.exception("Could not parse minecraft access token", oAuth);
        }
        String clientId = ParseUtil.encodeBase64(launcherClientId.toString());
        User user = new User(minecraftProfile.getId(), minecraftProfile.getName(), minecraftLogin.getAccessToken(), "msa", xuid, clientId);
        if (retrieveXBoxProfile) {
            callback.call(LoginState.XBOX_PROFILE);
            MicrosoftResponse<XSTSAuthorizeResponse, XSTSAuthorizeErrorResponse> xBoxXstsResponse = MicrosoftService.xstsAuthorize(xbl.getToken(), "http://xboxlive.com", xbl.getDisplayClaims(), timeoutValues);
            if (xBoxXstsResponse.hasException()) {
                return MicrosoftLoginRoutine.exception("Cannot authorize with xsts for xbox services", xBoxXstsResponse.getException().get(), oAuth);
            }
            if (xBoxXstsResponse.hasErrorResponse()) {
                return MicrosoftLoginRoutine.exception("Cannot authorize with xsts for xbox services because: " + xBoxXstsResponse.getErrorResponse().get(), oAuth);
            }
            XSTSAuthorizeResponse xBoxXsts = MicrosoftLoginRoutine.successResponse(xBoxXstsResponse);
            MicrosoftResponse<XBoxProfileResponse, Integer> xBoxProfileSettingsResponse = MicrosoftService.xboxProfileSettings(xBoxXsts.getToken(), xBoxXsts.getDisplayClaims(), timeoutValues);
            if (xBoxProfileSettingsResponse.hasException()) {
                return MicrosoftLoginRoutine.exception("Cannot get xbox profile data", xBoxProfileSettingsResponse.getException().get(), oAuth);
            }
            if (xBoxProfileSettingsResponse.hasErrorResponse()) {
                return MicrosoftLoginRoutine.exception("Cannot get xbox profile data because the service returned http code " + xBoxProfileSettingsResponse.getErrorResponse().get(), oAuth);
            }
            XBoxProfileResponse xBoxProfileSettings = MicrosoftLoginRoutine.successResponse(xBoxProfileSettingsResponse);
            XBoxProfileResponse.Profile profile = xBoxProfileSettings.getProfileUsers().get(0);
            xBoxProfile = Optional.of(new XBoxProfile(profile.getId(), profile.getSettings().stream().map(setting -> new XBoxProfile.XBoxProfileSettings(setting.getId(), setting.getValue())).collect(Collectors.toUnmodifiableList()), profile.isSponsoredUser()));
        } else {
            xBoxProfile = Optional.empty();
        }
        return MicrosoftLoginResponse.ofSuccess(user, xBoxProfile, oAuth.getRefreshToken());
    }

    private static <T> T successResponse(MicrosoftResponse<T, ?> response) {
        return response.getResponse().get();
    }

    private static MicrosoftLoginResponse exception(String message, Throwable throwable, OAuthTokenResponse oAuth) {
        return MicrosoftLoginRoutine.exception(message, throwable, Optional.of(oAuth.getRefreshToken()));
    }

    private static MicrosoftLoginResponse exception(String message, OAuthTokenResponse oAuth) {
        return MicrosoftLoginRoutine.exception(message, Optional.of(oAuth.getRefreshToken()));
    }

    private static MicrosoftLoginResponse exception(String message, Throwable throwable, Optional<String> refreshToken) {
        return MicrosoftLoginResponse.ofError(new MicrosoftAuthenticationException(message, throwable), refreshToken);
    }

    private static MicrosoftLoginResponse exception(String message, Optional<String> refreshToken) {
        return MicrosoftLoginResponse.ofError(new MicrosoftAuthenticationException(message), refreshToken);
    }
}

