/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login;

import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationException;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationFile;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.LoginState;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.User;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.XBoxProfile;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.AzureApplication;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftAuthentication;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftAuthenticationFile;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.MicrosoftLoginResponse;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.microsoft.service.MicrosoftService;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.ConnectionUtil;
import java.net.URL;
import java.util.Optional;

public class Authenticator {
    private final AuthenticationFileFunctionWithCustomAzureApplication fileFunction;
    private final boolean authenticate;
    private final boolean retrieveXBoxProfile;
    private final Optional<AzureApplication> customAzureApplication;
    private final ConnectionUtil.TimeoutValues timeoutValues;
    private boolean hasRun;
    private AuthenticationFile resultFile;
    private Optional<User> user;
    private Optional<XBoxProfile> xBoxProfile;

    public static Builder of(AuthenticationFile file) {
        return new Builder(timeoutValues -> file);
    }

    public static Builder ofMicrosoft(String authorizationCode) {
        return new Builder((customAzureApplication, timeoutValues) -> MicrosoftAuthentication.createAuthenticationFile(customAzureApplication, authorizationCode, timeoutValues));
    }

    public static URL microsoftLogin() {
        return MicrosoftService.oAuthLoginUrl();
    }

    public static String microsoftLoginRedirect() {
        return "https://login.live.com/oauth20_desktop.srf";
    }

    public static URL microsoftLogin(String clientId, String redirectUrl) {
        return MicrosoftService.oAuthLoginUrl(clientId, redirectUrl);
    }

    protected Authenticator(AuthenticationFileFunctionWithCustomAzureApplication fileFunction, boolean authenticate, boolean retrieveXBoxProfile, Optional<AzureApplication> customAzureApplication, ConnectionUtil.TimeoutValues timeoutValues) {
        this.fileFunction = fileFunction;
        this.authenticate = authenticate;
        this.retrieveXBoxProfile = retrieveXBoxProfile;
        this.customAzureApplication = customAzureApplication;
        this.timeoutValues = timeoutValues;
        this.user = Optional.empty();
        this.xBoxProfile = Optional.empty();
    }

    public void run() throws AuthenticationException {
        this.run(LoginStateCallback.NOOP);
    }

    public void run(LoginStateCallback callback) throws AuthenticationException {
        if (this.hasRun) {
            throw new IllegalStateException("Cannot run the authentication multiple times");
        }
        this.hasRun = true;
        callback.call(LoginState.INITAL_FILE);
        this.resultFile = this.fileFunction.get(this.customAzureApplication, this.timeoutValues);
        if (this.authenticate) {
            AuthenticationFile authenticationFile = this.resultFile;
            if (authenticationFile instanceof MicrosoftAuthenticationFile) {
                MicrosoftAuthenticationFile microsoftFile = (MicrosoftAuthenticationFile)authenticationFile;
                MicrosoftLoginResponse response = MicrosoftAuthentication.authenticate(this.customAzureApplication, this.retrieveXBoxProfile, microsoftFile, this.timeoutValues, callback);
                if (response.hasRefreshToken()) {
                    this.resultFile = new MicrosoftAuthenticationFile(microsoftFile.getClientId(), response.getRefreshToken().get());
                }
                if (response.hasException()) {
                    throw response.getException().get();
                }
                if (!response.hasUser()) {
                    throw new AuthenticationException("After login there should be a user");
                }
                this.user = response.getUser();
                if (this.retrieveXBoxProfile && !response.hasXBoxProfile()) {
                    throw new AuthenticationException("XBox profile was requested but is not there");
                }
                if (response.hasXBoxProfile()) {
                    this.xBoxProfile = response.getXBoxProfile();
                }
            } else {
                throw new AuthenticationException(this.resultFile + " is not a microsoft authentication file");
            }
        }
    }

    public AuthenticationFile getResultFile() {
        if (!this.hasRun) {
            throw new IllegalStateException("This method can only be called after the authentication was run");
        }
        return this.resultFile;
    }

    public Optional<User> getUser() {
        if (!this.hasRun) {
            throw new IllegalStateException("This method can only be called after the authentication was run");
        }
        return this.user;
    }

    public Optional<XBoxProfile> getXBoxProfile() {
        if (!this.hasRun) {
            throw new IllegalStateException("This method can only be called after the authentication was run");
        }
        return this.xBoxProfile;
    }

    public static class Builder {
        private final AuthenticationFileFunctionWithCustomAzureApplication fileFunction;
        private boolean authenticate;
        private boolean retrieveXBoxProfile;
        private Optional<AzureApplication> customAzureApplication;
        private int serviceConnectTimeout;
        private int serviceReadTimeout;

        protected Builder(AuthenticationFileFunction fileSupplier) {
            this((Optional<AzureApplication> customAzureApplication, ConnectionUtil.TimeoutValues timeoutValues) -> fileSupplier.get(timeoutValues));
        }

        protected Builder(AuthenticationFileFunctionWithCustomAzureApplication fileFunction) {
            this.fileFunction = fileFunction;
            this.authenticate = false;
            this.customAzureApplication = Optional.empty();
            this.serviceConnectTimeout = 15000;
            this.serviceReadTimeout = 15000;
        }

        public Builder shouldAuthenticate() {
            this.authenticate = true;
            return this;
        }

        public Builder shouldRetrieveXBoxProfile() {
            this.retrieveXBoxProfile = true;
            return this;
        }

        public Builder customAzureApplication(String clientId, String redirectUrl) {
            this.customAzureApplication = Optional.of(new AzureApplication(clientId, redirectUrl));
            return this;
        }

        public Builder customAzureApplication(String clientId, String redirectUrl, String clientSecret) {
            this.customAzureApplication = Optional.of(new AzureApplication(clientId, redirectUrl, clientSecret));
            return this;
        }

        public Builder serviceConnectTimeout(int timeout) {
            this.serviceConnectTimeout = timeout;
            return this;
        }

        public Builder serviceReadTimeout(int timeout) {
            this.serviceReadTimeout = timeout;
            return this;
        }

        public Authenticator build() {
            return new Authenticator(this.fileFunction, this.authenticate, this.retrieveXBoxProfile, this.customAzureApplication, new ConnectionUtil.TimeoutValues(this.serviceConnectTimeout, this.serviceReadTimeout));
        }
    }

    @FunctionalInterface
    protected static interface AuthenticationFileFunction {
        public AuthenticationFile get(ConnectionUtil.TimeoutValues var1) throws AuthenticationException;
    }

    @FunctionalInterface
    protected static interface AuthenticationFileFunctionWithCustomAzureApplication {
        public AuthenticationFile get(Optional<AzureApplication> var1, ConnectionUtil.TimeoutValues var2) throws AuthenticationException;
    }

    @FunctionalInterface
    public static interface LoginStateCallback {
        public static final LoginStateCallback NOOP = state -> {};

        public void call(LoginState var1);
    }
}

