/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login;

import com.google.gson.JsonObject;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.util.AuthenticationFileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public abstract class AuthenticationFile {
    private final UUID clientId;
    private final Map<String, String> extraProperties;

    protected AuthenticationFile(UUID clientId) {
        this.clientId = clientId;
        this.extraProperties = new HashMap<String, String>();
    }

    public UUID getClientId() {
        return this.clientId;
    }

    public Map<String, String> getExtraProperties() {
        return this.extraProperties;
    }

    public int hashCode() {
        return Objects.hash(this.clientId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AuthenticationFile other = (AuthenticationFile)obj;
        return Objects.equals(this.clientId, other.clientId);
    }

    public String toString() {
        return "AuthenticationFile [clientId=" + this.clientId + ", extraProperties=" + this.extraProperties + "]";
    }

    public static AuthenticationFile readCompressed(InputStream inputStream) throws IOException {
        return AuthenticationFileUtil.fromCompressedInputStream(inputStream);
    }

    public static AuthenticationFile readCompressed(byte[] bytes) throws IOException {
        return AuthenticationFileUtil.fromCompressedBytes(bytes);
    }

    public static AuthenticationFile readString(String string) throws IOException {
        return AuthenticationFileUtil.fromString(string);
    }

    public static AuthenticationFile deserialize(JsonObject object) throws IOException {
        return AuthenticationFileUtil.fromJson(object);
    }

    public void writeCompressed(OutputStream outputStream) throws IOException {
        AuthenticationFileUtil.toCompressedOutputStream(this, outputStream);
    }

    public byte[] writeCompressed() throws IOException {
        return AuthenticationFileUtil.toCompressedBytes(this);
    }

    public String writeString() {
        return AuthenticationFileUtil.toString(this);
    }

    public JsonObject serialize() {
        return AuthenticationFileUtil.toJson(this);
    }
}

