/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;

public class LoadingSpinnerWidget
extends AbstractWidget
implements PerspectiveRenderable {
    private static final ResourceLocation SPINNER = ResourceLocation.fromNamespaceAndPath((String)"oauthaccountmanager", (String)"textures/gui/spinner.png");
    private long lastTime;
    private int currentRotation;

    public LoadingSpinnerWidget(int x, int y, int width, int height) {
        super(x, y, width, height, CommonComponents.EMPTY);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBehind(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBehind(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)this.getX(), (float)this.getY(), 0.0f);
        float xRot = (float)this.width / 2.0f;
        float yRot = (float)this.height / 2.0f;
        poseStack.translate(xRot, yRot, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)this.currentRotation));
        poseStack.translate(-xRot, -yRot, 0.0f);
        RenderUtil.drawTexturedQuad((PoseStack)poseStack, (int)0, (int)(0 + this.width), (int)0, (int)(0 + this.height), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f, (ResourceLocation)SPINNER, (RGBA)RGBA.WHITE);
        poseStack.popPose();
        if (Util.getMillis() - this.lastTime > 10L) {
            this.lastTime = Util.getMillis();
            this.currentRotation += 2;
        }
    }

    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void updateWidgetNarration(NarrationElementOutput element) {
        this.defaultButtonNarrationText(element);
    }

    public void playDownSound(SoundManager pHandler) {
    }
}

