/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen.list;

import com.mojang.authlib.GameProfile;
import info.u_team.oauth_account_manager.screen.AccountUseScreen;
import info.u_team.oauth_account_manager.screen.list.AbstractAccountSelectionEntry;
import info.u_team.oauth_account_manager.screen.list.AccountSelectionList;
import info.u_team.oauth_account_manager.util.AuthenticationUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class LaunchedAccountSelectionEntry
extends AbstractAccountSelectionEntry {
    private static final AuthenticationUtil.MinecraftAccountData LAUNCHED_DATA;
    private static GameProfile LAUNCHED_GAME_PROFILE;

    public LaunchedAccountSelectionEntry(Screen ourScreen, AccountSelectionList selectionList) {
        super(ourScreen, selectionList, LAUNCHED_GAME_PROFILE.getId(), LAUNCHED_GAME_PROFILE);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
        super.render(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovered, partialTick);
        if (hovered && this.currentlyUsed) {
            this.ourScreen.setTooltipForNextRenderPass(this.minecraft.font.split((FormattedText)Component.translatable((String)"screen.oauthaccountmanager.accounts.list.launched.tooltip", (Object[])new Object[]{Component.translatable((String)"screen.oauthaccountmanager.accounts.list.used.tooltip")}), 175));
        }
    }

    @Override
    protected void useEntry() {
        AccountUseScreen useScreen = new AccountUseScreen(this.ourScreen, this.getProfile(), () -> LAUNCHED_DATA);
        this.minecraft.setScreen((Screen)useScreen);
    }

    @Override
    protected MutableComponent getTitleName() {
        return Component.translatable((String)"screen.oauthaccountmanager.accounts.list.launched.title", (Object[])new Object[]{super.getTitleName()}).withStyle(style -> style.withColor(0xCCCCCC).withItalic(Boolean.valueOf(true)));
    }

    static {
        Minecraft minecraft = Minecraft.getInstance();
        LAUNCHED_DATA = new AuthenticationUtil.MinecraftAccountData(minecraft.user, minecraft.profileFuture, minecraft.userApiService, minecraft.userPropertiesFuture, minecraft.playerSocialManager, minecraft.telemetryManager, minecraft.profileKeyPairManager, minecraft.reportingContext);
        LAUNCHED_GAME_PROFILE = minecraft.getGameProfile();
    }
}

