/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen.list;

import com.mojang.authlib.GameProfile;
import info.u_team.oauth_account_manager.screen.AccountCheckValidScreen;
import info.u_team.oauth_account_manager.screen.AccountLoginScreen;
import info.u_team.oauth_account_manager.screen.AccountUseScreen;
import info.u_team.oauth_account_manager.screen.list.AbstractAccountSelectionEntry;
import info.u_team.oauth_account_manager.screen.list.AccountSelectionList;
import info.u_team.oauth_account_manager.util.AuthenticationUtil;
import info.u_team.oauth_account_manager.util.LoadedAccount;
import info.u_team.oauth_account_manager.util.MinecraftAccounts;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.gui.screens.Screen;

public class AccountSelectionEntry
extends AbstractAccountSelectionEntry {
    public AccountSelectionEntry(Screen ourScreen, AccountSelectionList selectionList, UUID uuid, GameProfile profile) {
        super(ourScreen, selectionList, uuid, profile);
    }

    @Override
    protected void useEntry() {
        UUID uuid = this.getUuid();
        if (!MinecraftAccounts.isLoaded(uuid)) {
            this.showLoginScreen(uuid);
        } else {
            this.showUseScreen(uuid, () -> this.showLoginScreen(uuid));
        }
    }

    private void showLoginScreen(UUID uuid) {
        AccountLoginScreen loginScreen = new AccountLoginScreen(this.ourScreen);
        loginScreen.login(Optional.of(uuid), () -> AuthenticationUtil.createWebAuthenticationMethod().existingAuthentication(MinecraftAccounts.getAccount(uuid)), screen -> this.showUseScreen(uuid, () -> this.showLoginScreen(uuid)));
        this.minecraft.setScreen((Screen)loginScreen);
    }

    private void showUseScreen(UUID uuid, Runnable retry) {
        LoadedAccount loadedAccount = MinecraftAccounts.getLoadedAccount(uuid);
        if (loadedAccount == null) {
            retry.run();
            return;
        }
        AccountCheckValidScreen validScreen = new AccountCheckValidScreen(this.ourScreen, retry, () -> {
            AccountUseScreen useScreen = new AccountUseScreen(this.ourScreen, this.getProfile(), () -> AuthenticationUtil.createMinecraftAccountData(loadedAccount));
            this.minecraft.setScreen((Screen)useScreen);
        });
        validScreen.checkAccount(loadedAccount.user().accessToken());
        this.minecraft.setScreen((Screen)validScreen);
    }
}

