/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen;

import info.u_team.oauth_account_manager.screen.AccountsScreen;
import info.u_team.oauth_account_manager.util.AuthenticationUtil;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.util.RGBA;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MultiplayerScreenAdditions {
    private static final RGBA VALID_COLOR = RGBA.fromARGB((int)-13829117);
    private static final RGBA INVALID_COLOR = RGBA.fromARGB((int)-261373);

    public static UButton addButton(int width, Screen lastScreen) {
        UButton button = new UButton(0, 0, 74, 16, (Component)Component.translatable((String)"screen.oauthaccountmanager.multiplayer_addition.account_button"));
        FrameLayout.centerInRectangle((LayoutElement)button, (int)117, (int)0, (int)width, (int)45);
        button.setPressable(() -> Minecraft.getInstance().setScreen((Screen)new AccountsScreen(lastScreen)));
        button.setTooltip(Tooltip.create((Component)Component.translatable((String)"screen.oauthaccountmanager.multiplayer_addition.account_button.tooltip.checking")));
        User user = Minecraft.getInstance().getUser();
        AuthenticationUtil.isAccessTokenValid(user.getAccessToken()).thenAccept(isValid -> {
            MutableComponent tooltip;
            RGBA color;
            if (isValid.booleanValue()) {
                color = VALID_COLOR;
                tooltip = Component.translatable((String)"screen.oauthaccountmanager.multiplayer_addition.account_button.tooltip.valid", (Object[])new Object[]{user.getName()}).withStyle(ChatFormatting.GREEN);
            } else {
                color = INVALID_COLOR;
                tooltip = Component.translatable((String)"screen.oauthaccountmanager.multiplayer_addition.account_button.tooltip.invalid").withStyle(ChatFormatting.RED);
            }
            MinecraftExecutor.executeOnMainThread(() -> MultiplayerScreenAdditions.lambda$addButton$1(button, color, (Component)tooltip));
        });
        return button;
    }

    private static /* synthetic */ void lambda$addButton$1(UButton button, RGBA color, Component tooltip) {
        button.setButtonColor(color);
        button.setTooltip(Tooltip.create((Component)tooltip));
    }
}

