/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen;

import info.u_team.oauth_account_manager.screen.widget.LoadingSpinnerWidget;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.screen.UScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.EqualSpacingLayout;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class CommonWaitingScreen
extends UScreen {
    protected final Screen lastScreen;
    protected final Screen doneScreen;
    protected MultiLineTextWidget messageWidget;
    protected LoadingSpinnerWidget spinnerWidget;
    protected UButton doneButton;
    protected UButton cancelButton;
    protected Thread waitingThread;

    public CommonWaitingScreen(Screen lastScreen, Screen doneScreen, Component title) {
        super(title);
        this.lastScreen = lastScreen;
        this.doneScreen = doneScreen;
    }

    protected void init() {
        super.init();
        this.messageWidget = (MultiLineTextWidget)this.addRenderableWidget((GuiEventListener)new MultiLineTextWidget(0, this.height / 2 - 60, CommonComponents.EMPTY, this.font).setMaxWidth(this.width - 50).setCentered(true));
        this.spinnerWidget = (LoadingSpinnerWidget)this.addRenderableWidget((GuiEventListener)new LoadingSpinnerWidget(0, 0, 60, 60));
        FrameLayout.centerInRectangle((LayoutElement)this.spinnerWidget, (int)0, (int)0, (int)this.width, (int)this.height);
        this.doneButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 100, 20, CommonComponents.GUI_DONE));
        this.doneButton.setPressable(() -> this.minecraft.setScreen(this.doneScreen));
        this.doneButton.active = false;
        this.cancelButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 100, 20, CommonComponents.GUI_CANCEL));
        this.cancelButton.setPressable(this::cancelWaitingThread);
        EqualSpacingLayout layout = new EqualSpacingLayout(205, 20, EqualSpacingLayout.Orientation.HORIZONTAL);
        layout.addChild((LayoutElement)this.doneButton);
        layout.addChild((LayoutElement)this.cancelButton);
        layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)layout, (int)0, (int)(this.height - 64), (int)this.width, (int)64);
    }

    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public void onClose() {
        this.cancelWaitingThread();
    }

    protected void repositionElements() {
        Component messageWidgetMessage = this.messageWidget.getMessage();
        boolean spinnerWidgetActive = this.spinnerWidget.active;
        boolean spinnerWidgetVisible = this.spinnerWidget.visible;
        boolean doneButtonActive = this.doneButton.active;
        boolean cancelButtonActive = this.cancelButton.active;
        super.repositionElements();
        this.setInformationMessage(messageWidgetMessage);
        this.spinnerWidget.active = spinnerWidgetActive;
        this.spinnerWidget.visible = spinnerWidgetVisible;
        this.doneButton.active = doneButtonActive;
        this.cancelButton.active = cancelButtonActive;
    }

    protected void setInformationMessage(Component component) {
        this.messageWidget.setMessage(component);
        this.messageWidget.setX(this.width / 2 - this.messageWidget.getWidth() / 2);
    }

    protected void setFinalMessage(Component component) {
        this.setInformationMessage(component);
        this.doneButton.active = true;
        this.cancelButton.active = false;
        this.spinnerWidget.active = false;
        this.spinnerWidget.visible = false;
    }

    protected void cancelWaitingThread() {
        if (this.waitingThread != null) {
            this.waitingThread.interrupt();
        }
        this.minecraft.setScreen(this.lastScreen);
    }

    protected void createWaitingThread(Runnable runnable) {
        this.waitingThread = new Thread(runnable, "OAuth-Account-Manager-Waiter");
        this.waitingThread.setDaemon(true);
        this.waitingThread.start();
    }
}

