/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen;

import info.u_team.oauth_account_manager.screen.AddAccountOAuthScreen;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.method.AuthenticationMethod;
import info.u_team.oauth_account_manager.util.AuthenticationUtil;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.screen.UScreen;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.EqualSpacingLayout;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class AddAccountOpenLinkScreen
extends UScreen {
    private final Screen lastScreen;
    private MultiLineLabel message = MultiLineLabel.EMPTY;

    public AddAccountOpenLinkScreen(Screen lastScreen) {
        super((Component)Component.translatable((String)"screen.oauthaccountmanager.add_account_open_link.title"));
        this.lastScreen = lastScreen;
    }

    protected void init() {
        super.init();
        this.message = MultiLineLabel.create((Font)this.font, (Component)Component.translatable((String)"screen.oauthaccountmanager.add_account_open_link.message", (Object[])new Object[]{Component.translatable((String)"chat.link.open"), Component.translatable((String)"chat.copy")}), (int)(this.width - 50));
        UButton openLink = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 100, 20, (Component)Component.translatable((String)"chat.link.open")));
        openLink.setPressable(() -> this.startAuthenticationProcess(true));
        UButton copyClipboard = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 100, 20, (Component)Component.translatable((String)"chat.copy")));
        copyClipboard.setPressable(() -> this.startAuthenticationProcess(false));
        UButton cancelButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 100, 20, CommonComponents.GUI_CANCEL));
        cancelButton.setPressable(() -> this.minecraft.setScreen(this.lastScreen));
        EqualSpacingLayout layout = new EqualSpacingLayout(308, 20, EqualSpacingLayout.Orientation.HORIZONTAL);
        layout.addChild((LayoutElement)openLink);
        layout.addChild((LayoutElement)copyClipboard);
        layout.addChild((LayoutElement)cancelButton);
        layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)layout, (int)0, (int)(this.height - 64), (int)this.width, (int)64);
    }

    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{super.getNarrationMessage(), Component.translatable((String)"screen.oauthaccountmanager.add_account_open_link.message")});
    }

    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        this.message.renderCentered(guiGraphics, this.width / 2, this.height / 2 - 40);
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    private void startAuthenticationProcess(boolean open) {
        AuthenticationMethod method = AuthenticationUtil.createWebAuthenticationMethod();
        method.registerLoginUrlCallback(url -> MinecraftExecutor.executeOnMainThread(() -> {
            if (open) {
                Util.getPlatform().openUri(url.toString());
            } else {
                Minecraft.getInstance().keyboardHandler.setClipboard(url.toString());
            }
        }));
        AddAccountOAuthScreen screen = new AddAccountOAuthScreen(this.lastScreen);
        screen.authenticate(method);
        this.minecraft.setScreen((Screen)screen);
    }
}

