/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen;

import info.u_team.oauth_account_manager.OAuthAccountManagerReference;
import info.u_team.oauth_account_manager.screen.AccountLoginScreen;
import info.u_team.oauth_account_manager.screen.CommonWaitingScreen;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationException;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.method.AuthenticationMethod;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.result.AuthenticationResult;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class AddAccountOAuthScreen
extends CommonWaitingScreen {
    public AddAccountOAuthScreen(Screen lastScreen) {
        super(lastScreen, lastScreen, (Component)Component.translatable((String)"screen.oauthaccountmanager.add_account_information.title"));
    }

    @Override
    protected void init() {
        super.init();
        this.setInformationMessage((Component)Component.translatable((String)"screen.oauthaccountmanager.add_account_information.message.waiting_for_login"));
        this.spinnerWidget.setTooltip(Tooltip.create((Component)Component.translatable((String)"screen.oauthaccountmanager.add_account_information.spinner.tooltip.waiting")));
    }

    public void authenticate(AuthenticationMethod method) {
        this.createWaitingThread(() -> {
            AuthenticationResult result;
            try {
                result = method.initalAuthentication();
            }
            catch (AuthenticationException ex) {
                if (!(ex.getCause() instanceof InterruptedException)) {
                    MinecraftExecutor.executeOnMainThread(() -> this.setFinalMessage((Component)Component.translatable((String)"screen.oauthaccountmanager.add_account_information.message.error", (Object[])new Object[]{ex.getLocalizedMessage()})));
                    OAuthAccountManagerReference.LOGGER.warn("Microsoft OAuth didn't complete sucessfully", (Throwable)ex);
                }
                return;
            }
            MinecraftExecutor.executeOnMainThread(() -> {
                AccountLoginScreen screen = new AccountLoginScreen(this.lastScreen);
                screen.login(Optional.empty(), () -> result, null);
                Minecraft.getInstance().setScreen((Screen)screen);
            });
        });
    }
}

