/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen;

import info.u_team.oauth_account_manager.screen.AccountDeleteScreen;
import info.u_team.oauth_account_manager.screen.AddAccountOpenLinkScreen;
import info.u_team.oauth_account_manager.screen.MultiplayerScreenAdditions;
import info.u_team.oauth_account_manager.screen.list.AbstractAccountSelectionEntry;
import info.u_team.oauth_account_manager.screen.list.AccountSelectionEntry;
import info.u_team.oauth_account_manager.screen.list.AccountSelectionList;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.screen.UScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.EqualSpacingLayout;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class AccountsScreen
extends UScreen {
    private final Screen lastScreen;
    private final AccountSelectionList list;
    private UButton useButton;
    private UButton deleteButton;

    public AccountsScreen(Screen lastScreen) {
        super((Component)Component.translatable((String)"screen.oauthaccountmanager.accounts.title"));
        this.lastScreen = lastScreen;
        this.list = new AccountSelectionList((Screen)this){

            public void setSelected(AbstractAccountSelectionEntry selected) {
                super.setSelected((AbstractSelectionList.Entry)selected);
                AccountsScreen.this.updateButtonState(selected);
            }
        };
    }

    protected void init() {
        super.init();
        UButton button = (UButton)this.addRenderableWidget((GuiEventListener)MultiplayerScreenAdditions.addButton(this.width, this.lastScreen));
        button.setPressable(() -> this.resize(this.minecraft, this.width, this.height));
        this.addRenderableWidget((GuiEventListener)this.list);
        this.list.setRectangle(this.width, this.height - 64 - 32, 0, 32);
        this.useButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 74, 20, (Component)Component.translatable((String)"screen.oauthaccountmanager.accounts.use_button")));
        this.useButton.setPressable(this.list::useSelectedEntry);
        UButton addButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 74, 20, (Component)Component.translatable((String)"screen.oauthaccountmanager.accounts.add_button")));
        addButton.setPressable(() -> this.minecraft.setScreen((Screen)new AddAccountOpenLinkScreen((Screen)this)));
        this.deleteButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 74, 20, (Component)Component.translatable((String)"screen.oauthaccountmanager.accounts.delete_button")));
        this.deleteButton.setPressable(() -> {
            AbstractSelectionList.Entry patt0$temp = this.list.getSelected();
            if (patt0$temp instanceof AccountSelectionEntry) {
                AccountSelectionEntry entry = (AccountSelectionEntry)patt0$temp;
                this.minecraft.setScreen((Screen)new AccountDeleteScreen((Screen)this, entry.getProfile(), this.list::deleteSelectedEntry));
            }
        });
        UButton cancelButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 74, 20, CommonComponents.GUI_CANCEL));
        cancelButton.setPressable(() -> this.minecraft.setScreen(this.lastScreen));
        EqualSpacingLayout layout = new EqualSpacingLayout(308, 20, EqualSpacingLayout.Orientation.HORIZONTAL);
        layout.addChild((LayoutElement)this.useButton);
        layout.addChild((LayoutElement)addButton);
        layout.addChild((LayoutElement)this.deleteButton);
        layout.addChild((LayoutElement)cancelButton);
        layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)layout, (int)0, (int)(this.height - 64), (int)this.width, (int)64);
        this.updateButtonState(null);
        this.list.loadEntries();
    }

    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    public void updateButtonState(AbstractAccountSelectionEntry entry) {
        if (entry == null) {
            this.useButton.active = false;
            this.deleteButton.active = false;
        } else {
            this.useButton.active = true;
            this.deleteButton.active = entry instanceof AccountSelectionEntry;
        }
    }
}

