/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import info.u_team.oauth_account_manager.screen.widget.PlayerIconWidget;
import info.u_team.oauth_account_manager.util.AuthenticationUtil;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.screen.UScreen;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.EqualSpacingLayout;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class AccountUseScreen
extends UScreen {
    private final Screen lastScreen;
    private final GameProfile gameProfile;
    private final AccountDataCreator accountDataSupplier;
    private MultiLineTextWidget messageWidget;
    private PlayerIconWidget playerIconWidget;

    public AccountUseScreen(Screen lastScreen, GameProfile gameProfile, AccountDataCreator accountDataSupplier) {
        super((Component)Component.translatable((String)"screen.oauthaccountmanager.use_account.title"));
        this.lastScreen = lastScreen;
        this.gameProfile = gameProfile;
        this.accountDataSupplier = accountDataSupplier;
    }

    protected void init() {
        super.init();
        this.messageWidget = (MultiLineTextWidget)this.addRenderableWidget((GuiEventListener)new MultiLineTextWidget(0, this.height / 2 - 60, CommonComponents.EMPTY, this.font).setMaxWidth(this.width - 50).setCentered(true));
        this.setInformationMessage((Component)Component.translatable((String)"screen.oauthaccountmanager.use_account.message"));
        this.playerIconWidget = (PlayerIconWidget)this.addRenderableWidget((GuiEventListener)new PlayerIconWidget(this.width / 2 - 32, this.height / 2 - 32, 64, this.gameProfile));
        UButton doneButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 100, 20, CommonComponents.GUI_DONE));
        doneButton.setPressable(this::useAccount);
        UButton cancelButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(0, 0, 100, 20, CommonComponents.GUI_CANCEL));
        cancelButton.setPressable(() -> this.minecraft.setScreen(this.lastScreen));
        EqualSpacingLayout layout = new EqualSpacingLayout(205, 20, EqualSpacingLayout.Orientation.HORIZONTAL);
        layout.addChild((LayoutElement)doneButton);
        layout.addChild((LayoutElement)cancelButton);
        layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)layout, (int)0, (int)(this.height - 64), (int)this.width, (int)64);
    }

    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    protected void repositionElements() {
        Component messageWidgetMessage = this.messageWidget.getMessage();
        GameProfile profile = this.playerIconWidget.getProfile();
        super.repositionElements();
        this.setInformationMessage(messageWidgetMessage);
        this.playerIconWidget.setProfile(profile);
    }

    protected void setInformationMessage(Component component) {
        this.messageWidget.setMessage(component);
        this.messageWidget.setX(this.width / 2 - this.messageWidget.getWidth() / 2);
    }

    private void useAccount() {
        MinecraftExecutor.executeOnMainThread(() -> this.setInformationMessage((Component)Component.translatable((String)"screen.oauthaccountmanager.use_account.message.waiting")));
        CompletableFuture.runAsync(() -> {
            try {
                AuthenticationUtil.MinecraftAccountData data = this.accountDataSupplier.create();
                MinecraftExecutor.executeOnMainThread(() -> {
                    AuthenticationUtil.setMinecraftAccountData(data);
                    Minecraft.getInstance().setScreen(this.lastScreen);
                });
            }
            catch (AuthenticationException ex) {
                MinecraftExecutor.executeOnMainThread(() -> this.setInformationMessage((Component)Component.translatable((String)"screen.oauthaccountmanager.use_account.message.error")));
            }
        });
    }

    @FunctionalInterface
    public static interface AccountDataCreator {
        public AuthenticationUtil.MinecraftAccountData create() throws AuthenticationException;
    }
}

