/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.method;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationException;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationFile;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.Authenticator;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.method.AbstractAuthenticationMethod;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.result.AuthenticationResult;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.result.FileAuthenticationResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class WebAuthentication
extends AbstractAuthenticationMethod {
    protected static final String BASE_URL = "http://localhost:{port}";
    protected static final String FAVICON = "/favicon.ico";
    protected static final String BASE_PATH = "/ms-oauth";
    protected static final String LOGIN_PATH = "/ms-oauth/login";
    protected static final String REDIRECT_PATH = "/ms-oauth/response";
    protected static final String ERROR_PATH = "/ms-oauth/error";
    protected static final String SUCCESS_PATH = "/ms-oauth/success";
    protected static final String AZURE_CLIENT_ID = "78590d64-3549-4c5f-9ef5-add1e816fed1";
    protected static final String EXISTING_REDIRECT_URL = "http://localhost:{port}".replace("{port}", Integer.toString(9999) + "/ms-oauth/response");
    private HttpServer server;

    public WebAuthentication(PrintStream out, ExecutorService executor) {
        super(out, executor);
    }

    @Override
    public AuthenticationResult existingAuthentication(AuthenticationFile file) {
        return new FileAuthenticationResult(file, AZURE_CLIENT_ID, EXISTING_REDIRECT_URL, null);
    }

    @Override
    protected AuthenticationResult runInitalAuthentication() throws IOException, AuthenticationException {
        this.server = HttpServer.create(new InetSocketAddress(0), 0);
        int port = this.server.getAddress().getPort();
        String baseUrl = BASE_URL.replace("{port}", Integer.toString(port));
        URL loginUrl = new URL(baseUrl + LOGIN_PATH);
        this.loginUrlCallback.accept(loginUrl);
        this.out.println("Open the following link and log into your microsoft account.");
        this.out.println(loginUrl);
        String redirectUrl = baseUrl + REDIRECT_PATH;
        Function<HttpHandler, HttpHandler> defaultHandler = handler -> exchange -> {
            try (HttpExchange httpExchange = exchange;){
                if (!"GET".equals(exchange.getRequestMethod())) {
                    return;
                }
                exchange.getResponseHeaders().add("Server", "Minecraft Authenticator");
                handler.handle(exchange);
            }
        };
        BiFunction<String, String, HttpHandler> fileHandler = (file, contentType) -> (HttpHandler)defaultHandler.apply(exchange -> {
            byte[] bytes;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                WebAuthentication.class.getResourceAsStream("/html/" + file).transferTo(outputStream);
                bytes = outputStream.toByteArray();
            }
            exchange.getResponseHeaders().add("Content-Type", (String)contentType);
            exchange.sendResponseHeaders(200, bytes.length);
            exchange.getResponseBody().write(bytes);
        });
        this.server.createContext(FAVICON, fileHandler.apply("favicon.ico", "image/ico"));
        this.server.createContext(ERROR_PATH, fileHandler.apply("error.html", "text/html"));
        this.server.createContext(SUCCESS_PATH, fileHandler.apply("success.html", "text/html"));
        this.server.createContext(LOGIN_PATH, defaultHandler.apply(exchange -> {
            exchange.getResponseHeaders().add("Location", Authenticator.microsoftLogin(AZURE_CLIENT_ID, redirectUrl).toString());
            exchange.sendResponseHeaders(307, -1L);
        }));
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference authenticationFileReference = new AtomicReference();
        this.server.createContext(REDIRECT_PATH, defaultHandler.apply(exchange -> {
            Map<String, List<String>> query = this.splitQuery(exchange.getRequestURI().getQuery());
            List<String> codes = query.get("code");
            if (codes == null || codes.size() != 1) {
                exchange.getResponseHeaders().add("Location", ERROR_PATH);
                exchange.sendResponseHeaders(307, -1L);
                return;
            }
            Authenticator authenticator = Authenticator.ofMicrosoft(codes.get(0)).customAzureApplication(AZURE_CLIENT_ID, redirectUrl).build();
            try {
                authenticator.run();
            }
            catch (AuthenticationException ex) {
                exchange.getResponseHeaders().add("Location", ERROR_PATH);
                exchange.sendResponseHeaders(307, -1L);
                return;
            }
            exchange.getResponseHeaders().add("Location", SUCCESS_PATH);
            exchange.sendResponseHeaders(307, -1L);
            authenticationFileReference.set(authenticator.getResultFile());
            latch.countDown();
        }));
        this.server.start();
        try {
            latch.await();
            this.out.println("Login was sucessful. Wait 5 seconds for webpages to update");
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            return null;
        }
        AuthenticationFile authenticationFile = (AuthenticationFile)authenticationFileReference.get();
        if (authenticationFile == null) {
            return null;
        }
        return new FileAuthenticationResult(authenticationFile, AZURE_CLIENT_ID, redirectUrl, null);
    }

    @Override
    protected void finishInitalAuthentication() throws Exception {
        this.server.stop(0);
    }

    public Map<String, List<String>> splitQuery(String query) {
        if (query == null || query.isBlank()) {
            return Collections.emptyMap();
        }
        return Arrays.stream(query.split("&")).map(this::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String part) {
        int indexOfEqual = part.indexOf("=");
        String key = indexOfEqual > 0 ? part.substring(0, indexOfEqual) : part;
        String value = indexOfEqual > 0 && part.length() > indexOfEqual + 1 ? part.substring(indexOfEqual + 1) : null;
        return new AbstractMap.SimpleImmutableEntry<String, String>(URLDecoder.decode(key, StandardCharsets.UTF_8), URLDecoder.decode(value, StandardCharsets.UTF_8));
    }
}

