/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.method;

import info.u_team.oauth_account_manager.shade.net.hycrafthd.minecraft_authenticator.login.AuthenticationException;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.method.AuthenticationMethod;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.result.AuthenticationResult;
import info.u_team.oauth_account_manager.shade.net.hycrafthd.simple_minecraft_authenticator.util.AuthenticationFutureUtil;
import java.io.PrintStream;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public abstract class AbstractAuthenticationMethod
implements AuthenticationMethod {
    protected final PrintStream out;
    protected final ExecutorService executor;
    protected int timeout;
    protected Consumer<URL> loginUrlCallback;

    public AbstractAuthenticationMethod(PrintStream out, ExecutorService executor) {
        this.out = out;
        this.executor = executor;
        this.timeout = 300;
        this.loginUrlCallback = url -> {};
    }

    @Override
    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    @Override
    public void registerLoginUrlCallback(Consumer<URL> loginUrlCallback) {
        this.loginUrlCallback = loginUrlCallback;
    }

    @Override
    public AuthenticationResult initalAuthentication() throws AuthenticationException {
        try {
            AuthenticationResult authenticationResult = AuthenticationFutureUtil.runAuthentication(this.executor, this::runInitalAuthentication, this.timeout, false);
            return authenticationResult;
        }
        finally {
            try {
                this.finishInitalAuthentication();
            }
            catch (Exception exception) {}
        }
    }

    protected abstract AuthenticationResult runInitalAuthentication() throws Exception;

    protected abstract void finishInitalAuthentication() throws Exception;
}

