package info.u_team.oauth_account_manager.screen.list;

import com.mojang.authlib.GameProfile;

import info.u_team.oauth_account_manager.init.OAuthAccountManagerLocalization;
import info.u_team.oauth_account_manager.screen.AccountUseScreen;
import info.u_team.oauth_account_manager.util.AuthenticationUtil.MinecraftAccountData;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class LaunchedAccountSelectionEntry extends AbstractAccountSelectionEntry {
	
	private static final MinecraftAccountData LAUNCHED_DATA;
	private static GameProfile LAUNCHED_GAME_PROFILE;
	
	static {
		final class_310 minecraft = class_310.method_1551();
		LAUNCHED_DATA = new MinecraftAccountData(minecraft.field_1726, minecraft.field_45899, minecraft.field_26902, minecraft.field_47680, minecraft.field_26842, minecraft.field_41331, minecraft.field_39068, minecraft.field_39492);
		LAUNCHED_GAME_PROFILE = minecraft.method_53462();
	}
	
	public LaunchedAccountSelectionEntry(class_437 ourScreen, AccountSelectionList selectionList) {
		super(ourScreen, selectionList, LAUNCHED_GAME_PROFILE.getId(), LAUNCHED_GAME_PROFILE);
	}
	
	@Override
	public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
		super.method_25343(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovered, partialTick);
		if (hovered && currentlyUsed) {
			ourScreen.method_47414(minecraft.field_1772.method_1728(class_2561.method_43469(OAuthAccountManagerLocalization.SCREEN_ACCOUNTS_LIST_LAUNCHED_TOOLTIP, class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ACCOUNTS_LIST_USED_TOOLTIP)), 175));
		}
	}
	
	@Override
	protected void useEntry() {
		final AccountUseScreen useScreen = new AccountUseScreen(ourScreen, getProfile(), () -> LAUNCHED_DATA);
		minecraft.method_1507(useScreen);
	}
	
	@Override
	protected class_5250 getTitleName() {
		return class_2561.method_43469(OAuthAccountManagerLocalization.SCREEN_ACCOUNTS_LIST_LAUNCHED_TITLE, super.getTitleName()).method_27694(style -> style.method_36139(0xCCCCCC).method_10978(true));
	}
	
}
