package info.u_team.oauth_account_manager.screen.list;

import java.util.UUID;
import net.minecraft.class_1109;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7532;
import com.mojang.authlib.GameProfile;
import info.u_team.oauth_account_manager.init.OAuthAccountManagerLocalization;
import info.u_team.u_team_core.gui.elements.ScrollableListEntry;

public abstract class AbstractAccountSelectionEntry extends ScrollableListEntry<AbstractAccountSelectionEntry> {
	
	protected final class_437 ourScreen;
	private final AccountSelectionList selectionList;
	
	private final UUID uuid;
	private final GameProfile profile;
	
	protected final boolean currentlyUsed;
	
	private long lastClickTime;
	
	public AbstractAccountSelectionEntry(class_437 ourScreen, AccountSelectionList selectionList, UUID uuid, GameProfile profile) {
		this.ourScreen = ourScreen;
		this.selectionList = selectionList;
		this.uuid = uuid;
		this.profile = profile;
		this.currentlyUsed = uuid.equals(minecraft.method_1548().method_44717());
	}
	
	@Override
	public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
		final class_2960 skin = minecraft.method_1582().method_52862(profile).comp_1626();
		
		class_7532.method_44445(guiGraphics, skin, left, top, 32, false, false);
		
		guiGraphics.method_51439(minecraft.field_1772, getTitleName(), left + 35, top + 1, 0xFFFFFF, false);
		guiGraphics.method_51433(minecraft.field_1772, uuid.toString(), left + 35, top + 12, 0x808080, false);
		
		if (hovered && currentlyUsed) {
			ourScreen.method_47414(minecraft.field_1772.method_1728(class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ACCOUNTS_LIST_USED_TOOLTIP), 175));
		}
	}
	
	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (keyCode == class_3675.field_31957 || keyCode == class_3675.field_31980) {
			playClickSound();
			selectionList.useSelectedEntry();
		}
		return super.method_25404(keyCode, scanCode, modifiers);
	}
	
	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (class_156.method_658() - lastClickTime < 250) {
			playClickSound();
			selectionList.useSelectedEntry();
			return true;
		}
		lastClickTime = class_156.method_658();
		return super.method_25402(mouseX, mouseY, button);
	}
	
	private void playClickSound() {
		minecraft.method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0f));
	}
	
	@Override
	public class_2561 method_37006() {
		return class_2561.method_43470(profile.getName());
	}
	
	public UUID getUuid() {
		return uuid;
	}
	
	public GameProfile getProfile() {
		return profile;
	}
	
	protected abstract void useEntry();
	
	protected class_5250 getTitleName() {
		return class_2561.method_43470(profile.getName()).method_27694(style -> style.method_36139(currentlyUsed ? 0x55FF55 : 0xFFFFFF).method_10978(false));
	}
	
}
