package info.u_team.oauth_account_manager.screen;

import info.u_team.oauth_account_manager.init.OAuthAccountManagerLocalization;
import info.u_team.oauth_account_manager.util.AuthenticationUtil;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.util.RGBA;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_437;
import net.minecraft.class_7843;
import net.minecraft.class_7919;

public class MultiplayerScreenAdditions {
	
	private static final RGBA VALID_COLOR = RGBA.fromARGB(0xFF2CFC03);
	private static final RGBA INVALID_COLOR = RGBA.fromARGB(0xFFFC0303);
	
	public static UButton addButton(int width, class_437 lastScreen) {
		final UButton button = new UButton(0, 0, 74, 16, class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_MULTIPLAYER_ADDITION_ACCOUNT_BUTTON));
		class_7843.method_46442(button, 117, 0, width, 45);
		button.setPressable(() -> {
			class_310.method_1551().method_1507(new AccountsScreen(lastScreen));
		});
		button.method_47400(class_7919.method_47407(class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_MULTIPLAYER_ADDITION_ACCOUNT_BUTTON_TOOLTIP_CHECKING)));
		
		final class_320 user = class_310.method_1551().method_1548();
		AuthenticationUtil.isAccessTokenValid(user.method_1674()).thenAccept(isValid -> {
			final RGBA color;
			final class_2561 tooltip;
			if (isValid) {
				color = VALID_COLOR;
				tooltip = class_2561.method_43469(OAuthAccountManagerLocalization.SCREEN_MULTIPLAYER_ADDITION_ACCOUNT_BUTTON_TOOLTIP_VALID, user.method_1676()).method_27692(class_124.field_1060);
			} else {
				color = INVALID_COLOR;
				tooltip = class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_MULTIPLAYER_ADDITION_ACCOUNT_BUTTON_TOOLTIP_INVALID).method_27692(class_124.field_1061);
			}
			MinecraftExecutor.executeOnMainThread(() -> {
				button.setButtonColor(color);
				button.method_47400(class_7919.method_47407(tooltip));
			});
		});
		return button;
	}
	
}
