package info.u_team.oauth_account_manager.screen;

import info.u_team.oauth_account_manager.screen.widget.LoadingSpinnerWidget;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.screen.UScreen;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7843;
import net.minecraft.class_7849;
import net.minecraft.class_7940;

public class CommonWaitingScreen extends UScreen {
	
	protected final class_437 lastScreen;
	protected final class_437 doneScreen;
	
	protected class_7940 messageWidget;
	protected LoadingSpinnerWidget spinnerWidget;
	protected UButton doneButton;
	protected UButton cancelButton;
	
	protected Thread waitingThread;
	
	public CommonWaitingScreen(class_437 lastScreen, class_437 doneScreen, class_2561 title) {
		super(title);
		this.lastScreen = lastScreen;
		this.doneScreen = doneScreen;
	}
	
	@Override
	protected void method_25426() {
		super.method_25426();
		
		messageWidget = method_37063(new class_7940(0, (field_22790 / 2) - 60, class_5244.field_39003, field_22793).method_48984(field_22789 - 50).method_48981(true));
		
		spinnerWidget = method_37063(new LoadingSpinnerWidget(0, 0, 60, 60));
		class_7843.method_46442(spinnerWidget, 0, 0, field_22789, field_22790);
		
		doneButton = method_37063(new UButton(0, 0, 100, 20, class_5244.field_24334));
		doneButton.setPressable(() -> field_22787.method_1507(doneScreen));
		doneButton.field_22763 = false;
		
		cancelButton = method_37063(new UButton(0, 0, 100, 20, class_5244.field_24335));
		cancelButton.setPressable(this::cancelWaitingThread);
		
		final class_7849 layout = new class_7849(205, 20, class_7849.class_7851.field_40789);
		layout.method_46495(doneButton);
		layout.method_46495(cancelButton);
		layout.method_48222();
		
		class_7843.method_46442(layout, 0, field_22790 - 64, field_22789, 64);
	}
	
	@Override
	public void renderBefore(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		super.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
		
		guiGraphics.method_27534(field_22793, field_22785, field_22789 / 2, 20, 0xFFFFFF);
	}
	
	@Override
	public void method_25419() {
		cancelWaitingThread();
	}
	
	@Override
	protected void method_48640() {
		final class_2561 messageWidgetMessage = messageWidget.method_25369();
		final boolean spinnerWidgetActive = spinnerWidget.field_22763;
		final boolean spinnerWidgetVisible = spinnerWidget.field_22764;
		final boolean doneButtonActive = doneButton.field_22763;
		final boolean cancelButtonActive = cancelButton.field_22763;
		super.method_48640();
		setInformationMessage(messageWidgetMessage);
		spinnerWidget.field_22763 = spinnerWidgetActive;
		spinnerWidget.field_22764 = spinnerWidgetVisible;
		doneButton.field_22763 = doneButtonActive;
		cancelButton.field_22763 = cancelButtonActive;
	}
	
	protected void setInformationMessage(class_2561 component) {
		messageWidget.method_25355(component);
		messageWidget.method_46421((field_22789 / 2) - (messageWidget.method_25368() / 2));
	}
	
	protected void setFinalMessage(class_2561 component) {
		setInformationMessage(component);
		doneButton.field_22763 = true;
		cancelButton.field_22763 = false;
		spinnerWidget.field_22763 = false;
		spinnerWidget.field_22764 = false;
	}
	
	protected void cancelWaitingThread() {
		if (waitingThread != null) {
			waitingThread.interrupt();
		}
		field_22787.method_1507(lastScreen);
	}
	
	protected void createWaitingThread(Runnable runnable) {
		waitingThread = new Thread(runnable, "OAuth-Account-Manager-Waiter");
		waitingThread.setDaemon(true);
		waitingThread.start();
	}
}
