package info.u_team.oauth_account_manager.screen;

import java.util.Optional;

import info.u_team.oauth_account_manager.OAuthAccountManagerReference;
import info.u_team.oauth_account_manager.init.OAuthAccountManagerLocalization;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import net.hycrafthd.minecraft_authenticator.login.AuthenticationException;
import net.hycrafthd.simple_minecraft_authenticator.method.AuthenticationMethod;
import net.hycrafthd.simple_minecraft_authenticator.result.AuthenticationResult;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public class AddAccountOAuthScreen extends CommonWaitingScreen {
	
	public AddAccountOAuthScreen(class_437 lastScreen) {
		super(lastScreen, lastScreen, class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ADD_ACCOUNT_INFORMATION_TITLE));
	}
	
	@Override
	protected void method_25426() {
		super.method_25426();
		setInformationMessage(class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ADD_ACCOUNT_INFORMATION_MESSAGE_WAITING_FOR_LOGIN));
		spinnerWidget.method_47400(class_7919.method_47407(class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ADD_ACCOUNT_INFORMATION_SPINNER_TOOLTIP_WAITING)));
	}
	
	public void authenticate(AuthenticationMethod method) {
		createWaitingThread(() -> {
			final AuthenticationResult result;
			try {
				result = method.initalAuthentication();
			} catch (final AuthenticationException ex) {
				if (!(ex.getCause() instanceof InterruptedException)) {
					MinecraftExecutor.executeOnMainThread(() -> setFinalMessage(class_2561.method_43469(OAuthAccountManagerLocalization.SCREEN_ADD_ACCOUNT_INFORMATION_MESSAGE_ERROR, ex.getLocalizedMessage())));
					OAuthAccountManagerReference.LOGGER.warn("Microsoft OAuth didn't complete sucessfully", ex);
				}
				return;
			}
			
			MinecraftExecutor.executeOnMainThread(() -> {
				final AccountLoginScreen screen = new AccountLoginScreen(lastScreen);
				screen.login(Optional.empty(), () -> result, null);
				class_310.method_1551().method_1507(screen);
			});
		});
	}
}
