package info.u_team.oauth_account_manager.screen;

import com.mojang.authlib.GameProfile;

import info.u_team.oauth_account_manager.init.OAuthAccountManagerLocalization;
import info.u_team.oauth_account_manager.screen.widget.PlayerIconWidget;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.screen.UScreen;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7843;
import net.minecraft.class_7849;
import net.minecraft.class_7940;

public class AccountDeleteScreen extends UScreen {
	
	private final class_437 lastScreen;
	
	private final GameProfile gameProfile;
	private final Runnable deleteCallback;
	
	private class_7940 messageWidget;
	private PlayerIconWidget playerIconWidget;
	
	public AccountDeleteScreen(class_437 lastScreen, GameProfile gameProfile, Runnable deleteCallback) {
		super(class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_DELETE_ACCOUNT_TITLE));
		this.lastScreen = lastScreen;
		this.gameProfile = gameProfile;
		this.deleteCallback = deleteCallback;
	}
	
	@Override
	protected void method_25426() {
		super.method_25426();
		
		messageWidget = method_37063(new class_7940(0, (field_22790 / 2) - 60, class_5244.field_39003, field_22793).method_48984(field_22789 - 50).method_48981(true));
		setInformationMessage(class_2561.method_43469(OAuthAccountManagerLocalization.SCREEN_DELETE_ACCOUNT_MESSAGE, gameProfile.getName()));
		
		playerIconWidget = method_37063(new PlayerIconWidget(field_22789 / 2 - 32, field_22790 / 2 - 32, 64, gameProfile));
		
		final UButton deleteButton = method_37063(new UButton(0, 0, 100, 20, class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_DELETE_ACCOUNT_DELETE_BUTTON)));
		deleteButton.setPressable(() -> {
			deleteCallback.run();
			field_22787.method_1507(lastScreen);
		});
		
		final UButton cancelButton = method_37063(new UButton(0, 0, 100, 20, class_5244.field_24335));
		cancelButton.setPressable(() -> field_22787.method_1507(lastScreen));
		
		final class_7849 layout = new class_7849(205, 20, class_7849.class_7851.field_40789);
		layout.method_46495(deleteButton);
		layout.method_46495(cancelButton);
		layout.method_48222();
		
		class_7843.method_46442(layout, 0, field_22790 - 64, field_22789, 64);
	}
	
	@Override
	public void renderBefore(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		super.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
		
		guiGraphics.method_27534(field_22793, field_22785, field_22789 / 2, 20, 0xFFFFFF);
	}
	
	@Override
	public void method_25419() {
		field_22787.method_1507(lastScreen);
	}
	
	@Override
	protected void method_48640() {
		final class_2561 messageWidgetMessage = messageWidget.method_25369();
		final GameProfile profile = playerIconWidget.getProfile();
		super.method_48640();
		setInformationMessage(messageWidgetMessage);
		playerIconWidget.setProfile(profile);
	}
	
	protected void setInformationMessage(class_2561 component) {
		messageWidget.method_25355(component);
		messageWidget.method_46421((field_22789 / 2) - (messageWidget.method_25368() / 2));
	}
}
