package info.u_team.oauth_account_manager.screen;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7843;
import net.minecraft.class_7849;
import net.minecraft.class_7940;
import info.u_team.oauth_account_manager.init.OAuthAccountManagerLocalization;
import info.u_team.oauth_account_manager.util.AuthenticationUtil;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.screen.UScreen;

public class AccountCheckValidScreen extends UScreen {
	
	private final class_437 lastScreen;
	private final Runnable retryCallback;
	private final Runnable validCallback;
	
	private CompletableFuture<?> future;
	
	private class_7940 messageWidget;
	private UButton retryButton;
	private UButton cancelButton;
	
	public AccountCheckValidScreen(class_437 lastScreen, Runnable retryCallback, Runnable validCallback) {
		super(class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_CHECK_ACCOUNT_VALID_TITLE));
		this.lastScreen = lastScreen;
		this.retryCallback = retryCallback;
		this.validCallback = validCallback;
	}
	
	@Override
	protected void method_25426() {
		super.method_25426();
		
		messageWidget = method_37063(new class_7940(0, (field_22790 / 2) - 20, class_5244.field_39003, field_22793).method_48984(field_22789 - 50).method_48981(true));
		setInformationMessage(class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_CHECK_ACCOUNT_VALID_MESSAGE_CHECKING));
		
		retryButton = method_37063(new UButton(0, 0, 100, 20, class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_CHECK_ACCOUNT_VALID_BUTTON_RETRY)));
		retryButton.setPressable(retryCallback::run);
		retryButton.field_22763 = false;
		
		cancelButton = method_37063(new UButton(0, 0, 100, 20, class_5244.field_24335));
		cancelButton.setPressable(this::cancelChecking);
		
		final class_7849 layout = new class_7849(205, 20, class_7849.class_7851.field_40789);
		layout.method_46495(retryButton);
		layout.method_46495(cancelButton);
		layout.method_48222();
		
		class_7843.method_46442(layout, 0, field_22790 - 64, field_22789, 64);
	}
	
	@Override
	public void renderBefore(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		super.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
		
		guiGraphics.method_27534(field_22793, field_22785, field_22789 / 2, 20, 0xFFFFFF);
	}
	
	@Override
	public void method_25419() {
		cancelChecking();
	}
	
	@Override
	protected void method_48640() {
		final class_2561 messageWidgetMessage = messageWidget.method_25369();
		final boolean retryButtonActive = retryButton.field_22763;
		super.method_48640();
		setInformationMessage(messageWidgetMessage);
		retryButton.field_22763 = retryButtonActive;
	}
	
	protected void setInformationMessage(class_2561 component) {
		messageWidget.method_25355(component);
		messageWidget.method_46421((field_22789 / 2) - (messageWidget.method_25368() / 2));
	}
	
	protected void cancelChecking() {
		if (future != null) {
			future.cancel(false);
		}
		field_22787.method_1507(lastScreen);
	}
	
	public void checkAccount(String accessToken) {
		future = AuthenticationUtil.isAccessTokenValid(accessToken).orTimeout(30, TimeUnit.SECONDS).thenAccept(valid -> {
			MinecraftExecutor.executeOnMainThread(() -> {
				if (valid) {
					validCallback.run();
				} else {
					retryButton.field_22763 = true;
					setInformationMessage(class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_CHECK_ACCOUNT_VALID_MESSAGE_INVALID));
				}
			});
		});
	}
}
