/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.oauth_account_manager.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.util.UndashedUuid;
import info.u_team.oauth_account_manager.OAuthAccountManagerReference;
import info.u_team.oauth_account_manager.screen.CommonWaitingScreen;
import info.u_team.oauth_account_manager.screen.widget.PlayerIconWidget;
import info.u_team.oauth_account_manager.util.LoadedAccount;
import info.u_team.oauth_account_manager.util.MinecraftAccounts;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.hycrafthd.minecraft_authenticator.login.AuthenticationException;
import net.hycrafthd.minecraft_authenticator.login.Authenticator;
import net.hycrafthd.minecraft_authenticator.login.LoginState;
import net.hycrafthd.minecraft_authenticator.login.User;
import net.hycrafthd.minecraft_authenticator.login.XBoxProfile;
import net.hycrafthd.simple_minecraft_authenticator.SimpleMinecraftAuthentication;
import net.hycrafthd.simple_minecraft_authenticator.result.AuthenticationResult;
import net.hycrafthd.simple_minecraft_authenticator.util.AuthenticationFutureUtil;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public class AccountLoginScreen
extends CommonWaitingScreen {
    private PlayerIconWidget playerIconWidget;

    public AccountLoginScreen(class_437 lastScreen) {
        super(lastScreen, lastScreen, (class_2561)class_2561.method_43471((String)"screen.oauthaccountmanager.account_login.title"));
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.setInformationMessage(this.getLoginStateComponent(LoginState.INITAL_FILE));
        this.spinnerWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screen.oauthaccountmanager.account_login.spinner.tooltip.logging")));
        this.playerIconWidget = (PlayerIconWidget)this.method_37063((class_364)new PlayerIconWidget(this.field_22789 / 2 - 32, this.field_22790 / 2 - 32, 64, null));
    }

    @Override
    protected void method_48640() {
        GameProfile profile = this.playerIconWidget.getProfile();
        super.method_48640();
        this.playerIconWidget.setProfile(profile);
    }

    private class_2561 getLoginStateComponent(LoginState state) {
        return class_2561.method_43471((String)(switch (state) {
            default -> throw new MatchException(null, null);
            case LoginState.INITAL_FILE -> "screen.oauthaccountmanager.account_login.login_state_info.inital_file";
            case LoginState.LOGIN_MICOSOFT -> "screen.oauthaccountmanager.account_login.login_state_info.login_microsoft";
            case LoginState.XBL_TOKEN -> "screen.oauthaccountmanager.account_login.login_state_info.xbl_token";
            case LoginState.XSTS_TOKEN -> "screen.oauthaccountmanager.account_login.login_state_info.xsts_token";
            case LoginState.ACCESS_TOKEN -> "screen.oauthaccountmanager.account_login.login_state_info.access_token";
            case LoginState.ENTITLEMENT -> "screen.oauthaccountmanager.account_login.login_state_info.entitlement";
            case LoginState.PROFILE -> "screen.oauthaccountmanager.account_login.login_state_info.profile";
            case LoginState.XBOX_PROFILE -> "screen.oauthaccountmanager.account_login.login_state_info.xbox_profile";
        }));
    }

    public void login(Optional<UUID> accountUUID, Supplier<AuthenticationResult> authenticationResult, Consumer<AccountLoginScreen> callback) {
        this.createWaitingThread(() -> {
            UUID uuid2;
            Authenticator authenticator = ((AuthenticationResult)authenticationResult.get()).buildAuthenticator(true);
            try {
                AuthenticationFutureUtil.runAuthentication((ExecutorService)SimpleMinecraftAuthentication.getExecutor(), () -> {
                    authenticator.run(state -> MinecraftExecutor.executeOnMainThread(() -> this.setInformationMessage(this.getLoginStateComponent(state))));
                    return null;
                }, (int)300, (boolean)true);
            }
            catch (AuthenticationException ex) {
                if (!(ex.getCause() instanceof InterruptedException)) {
                    MinecraftExecutor.executeOnMainThread(() -> this.setFinalMessage((class_2561)class_2561.method_43469((String)"screen.oauthaccountmanager.account_login.message.error", (Object[])new Object[]{ex.getLocalizedMessage()})));
                    OAuthAccountManagerReference.LOGGER.warn("Authentication with minecraft services didn't complete sucessfully", (Throwable)ex);
                }
                accountUUID.ifPresent(uuid -> {
                    if (authenticator.getResultFile() != null) {
                        MinecraftAccounts.updateAuthenticationFile(uuid, authenticator.getResultFile());
                    }
                });
                return;
            }
            User user = (User)authenticator.getUser().orElseThrow(AssertionError::new);
            XBoxProfile xboxProfile = (XBoxProfile)authenticator.getXBoxProfile().orElseThrow(AssertionError::new);
            try {
                uuid2 = UndashedUuid.fromStringLenient((String)user.uuid());
                if (accountUUID.isPresent() && !((UUID)accountUUID.get()).equals(uuid2)) {
                    throw new IllegalArgumentException("UUID returned from minecraft services did not match existing uuid for that account");
                }
            }
            catch (IllegalArgumentException ex) {
                MinecraftExecutor.executeOnMainThread(() -> this.setFinalMessage((class_2561)class_2561.method_43469((String)"screen.oauthaccountmanager.account_login.message.error", (Object[])new Object[]{ex.getLocalizedMessage()})));
                OAuthAccountManagerReference.LOGGER.error("Cannot add minecraft account", (Throwable)ex);
                return;
            }
            GameProfile profile = this.field_22787.method_1495().fetchProfile(uuid2, true).profile();
            MinecraftAccounts.addAccount(uuid2, authenticator.getResultFile(), profile, new LoadedAccount(user, xboxProfile));
            MinecraftExecutor.executeOnMainThread(() -> {
                this.playerIconWidget.setProfile(profile);
                this.setFinalMessage((class_2561)class_2561.method_43469((String)"screen.oauthaccountmanager.account_login.message.success", (Object[])new Object[]{((User)authenticator.getUser().get()).name()}));
                if (callback != null) {
                    callback.accept(this);
                }
            });
        });
    }
}

